#ifndef __INPUT_H__
#define __INPUT_H__

////////////////////////////////////////////////////////////////////////////////
// Definition of an input server class. The class supports input devices and  //
// pixmaps as input sensitive objects. Further object types may be supported  //
// in subclasses and by overloading "rt_InputServer".                         //  
// LAST EDIT: Fri Aug  5 09:23:07 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../rlist.h"
#include "../object.h"
#include "event.h"

class RT_InputServer:public RT_GeneralList {
  public:
    // the standard polling loop - non blocking:
    void event(RT_Event * = 0); 
    // you can also send explicite an event to the input devices
    // the non-returning event loop:
    void loop() { while (1) event(); }
    void addObject(RT_Object *o) { append( (RT_GeneralListEntry*)o ); }
    void removeObject(RT_Object *o) { remove( (RT_GeneralListEntry*)o ); }
};

extern RT_InputServer *rt_InputServer;

#endif


