#ifndef __FILEDEVICE_H__
#define __FILEDEVICE_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of a class that encapsulates UNIX file handlers.               //  
//  LAST EDIT: Fri Aug  5 09:23:07 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "device.h"

extern const char *RTN_FILE_DEVICE;

class RT_FileDevice: public RT_InputDevice {
    long fd; // the file descriptor
    int mode; // the access mode
    struct timeval wait; // time out val
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int usF, usG, usV;
    static int scF, scG, scV;
  public:
    void event(RT_Event *); 
    void printCon( FILE *f ) const {
	RT_Object::printCon( f);
	fprintf( f, "%i %i", fd, mode );
    }
    void print( FILE *f ) const {
	RT_InputDevice::print( f );
	if (wait.tv_sec || wait.tv_usec) 
	    fprintf( f, "%s -second %i -micro %i \n", get_name(), wait.tv_sec, wait.tv_usec );   
    }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
    int objectCMD(char *[]); 

    //#### Tcl/C++ methods:
    RT_FileDevice(char *_name, long _fd, int _mode ): RT_InputDevice(_name) 
	{ fd = _fd; mode = _mode; wait.tv_sec = 0; wait.tv_usec= 0; } 

    const char *get_description() const { return "This is a device for file related events."; }

    const char *get_class() const { return RTN_FILE_DEVICE; } 

    int isA(const char *c) const { return RT_InputDevice::isA( c ) || RTM_isA( RTN_FILE_DEVICE, c ); }

    // the time out value:
    void micro(int _m) { wait.tv_usec = _m; }
    int get_micro() const { return wait.tv_usec; }

    void second(int _m) { wait.tv_sec = _m; }
    int get_second() const { return wait.tv_sec; }
};

#endif
