#ifndef __EVENT_H__
#define __EVENT_H__

////////////////////////////////////////////////////////////////////////////////
//  Definitions of event classes.                                             //  
//  LAST EDIT: Fri Aug  5 09:23:08 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../rlist.h"
#include "../primitiv.h"

extern "C" {
#include <sys/time.h>
}

typedef time_t RT_Time; // a long

extern const char *RTN_EVENT;

class RT_Event: public RT_GeneralListEntry {
    // abstract base class for all events
  protected:
    RT_Event() { time = (RT_Time)::time( 0 );}
    // some systems (AIX etc.) do not have a parameter for time():
    // you should use following:
    // ... time = (RT_Time)::time();
    
    RT_Time time; // the time of the event
  public:
    int isA(const char *_c) const { return RTM_isA( _c, RTN_EVENT ); }
    virtual const char *getClass() const = 0;
    virtual const char *getValue() const;
    const RT_Time &getTime() const { return time; }
    void print(FILE *f) const { fputs( getValue(), f); fputc( '\n', f ); }
};

extern const char *RTN_BUTTON_EVENT;

class RT_ButtonEvent: public RT_Event {
    // an event representing mouse press/release actions
  public:
    //#### data:
    int left, middle, right;
    int shift, ctrl, alt;
    int x, y, w, h;
    //#### public methods:
    RT_ButtonEvent() {
	left = middle = right = x = y = w = h = shift = ctrl = alt = 0 ;
    }
    int isA(const char *_c) const { return RTM_isA( _c, RTN_BUTTON_EVENT ) || RT_Event::isA( _c ); }
    const char *getClass() const { return RTN_BUTTON_EVENT; }
    const char* getValue() const;
};

extern const char *RTN_MOTION_EVENT;

class RT_MotionEvent:public RT_Event {
    // events representing mouse motions
  public:
    //#### data:
    int left, middle, right;
    int shift, ctrl, alt;
    int x, y, w, h;
    //#### public methods:
    RT_MotionEvent() { 
	left = middle = right = x = y = w = h = shift = ctrl = alt = 0;
    }
    int isA(const char *_c) const { return RTM_isA( _c, RTN_MOTION_EVENT ) || RT_Event::isA( _c ); }
    const char *getClass() const { return RTN_MOTION_EVENT; }
    const char* getValue() const;
};

extern const char *RTN_SPACEBALL_EVENT;

class RT_SpaceballEvent: public RT_Event {
    // events representing spaceball actions 
  public:
    //#### data:
    // the translation values of the spaceball:
    short transX, transY, transZ;
    // the rotation values of the spaceball:
    short twistX, twistY, twistZ;
    // the button states:
    short b1, b2, b3, b4, b5, b6, b7, b8;
    // the state of the pickbutton:
    short pick;
    // the number of periods of 0.25 ms since sending the last non-0
    // set of Spaceball data:
    short period;
    //#### public methods:
    RT_SpaceballEvent() {
	transX = transY = transZ = 0;
	twistX = twistY = twistZ = 0;
	b1 = b2 = b3 = b4 = b5 = b6 = b7 = b8 = 0;
	pick=0;
    }

    int isA(const char *_c) const { return RTM_isA( _c, RTN_SPACEBALL_EVENT ) || RT_Event::isA( _c ); }
    const char *getClass() const { return RTN_SPACEBALL_EVENT; }
    const char* getValue() const;
};

extern const char *RTN_UPDATE_EVENT;

class RT_UpdateEvent: public RT_Event {
    // pixmaps generate this event to force an update by the camera
  public:
    //#### data:
    int partial;
    // if 1 the following coordinates are valid:  
    // (x0,y0) left upper corner of the area that must be updated
    // (x1,y1) right lower corner 
    int x0, y0, x1, y1;
    //#### public methods:
    RT_UpdateEvent() { partial = 0; }
    int isA(const char *_c) const { return RTM_isA( _c, RTN_UPDATE_EVENT ) || RT_Event::isA( _c ); }
    const char *getClass() const { return RTN_UPDATE_EVENT; }
    const char* getValue() const; 
};

#endif

