////////////////////////////////////////////////////////////////////////////////
//  Implementation of methods of the base class for input devices.            //  
//  LAST EDIT: Fri Sep 23 16:37:22 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "device.h"
#include "input.h"
#include "../camera.h"

const char *RTN_CALLBACK = "Callback";
const char *RTN_INPUT_DEVICE = "InputDevice";

void RT_TclCallback::exec(RT_InputDevice *param) {
    RT_String code = name;
    code += ' ';
    code += param->get_name();
    if (Tcl_Eval( rt_Ip, code.getValue() ) == TCL_ERROR ) {
	static RT_String msg(100);
	msg = "Error in Tcl callback \"";
	msg += name;
	msg += "\": ";
	msg += rt_Ip->result;
	msg += " This callback was removed.";
	rt_Output->warning( msg.getValue() );

	// remove the callback if anything was wrong:
	list->remove( this );
    }
}

RT_InputDevice::~RT_InputDevice() { 
    if (xfather) {
	// remove it from the father list:
	if (xfather->isA( RTN_INPUT_DEVICE ))
	    ((RT_InputDevice *)xfather)->removeChild( this );
    }
    // remove it from the global list:
    else rt_InputServer->removeObject( this ); 
    // destroy the kids:

    class LFunctoid: public RT_GeneralListFunctoid {
      public:
	void exec(RT_GeneralListEntry *e, void * = 0) { delete e; }
    } func;
    cldList.doWithElements( &func );
}

int RT_InputDevice::objectCMD(char *argv[]) { 
    RT_parseTable( argv, table );
    int ret = 0;
    if (addCBF) {
	if (addTclCB( addCBV )) ret++;
	else Tcl_AppendResult(rt_Ip, "There is already a callback \"", addCBV, "\" in device \"", get_name(), "\". ", NULL );
    }
    if (remCBF) {
	if (removeTclCB( remCBV )) ret++; 
	else Tcl_AppendResult(rt_Ip, "There is no such a callback \"", remCBV, "\" in device \"", get_name(), "\". ", NULL );
    }

    if (onF) { on(); ret++; }
    if (offF) { off(); ret++; }
    if (onG) {
	RT_Object::result( get_on() ? "1" : "0" );
	ret++;
    }
    if (camG) {
	RT_Object::result( get_camera() ? get_camera()->get_name() : "" );
	ret++;
    }
    if (timeG) {
	char tmp[20];
	sprintf(tmp,"%d",get_time());
	RT_Object::result(tmp); 
	ret++;
    }
    if (fatherG) {
	RT_Object::result( get_father() ? get_father()->get_name() : "" );
	ret++;
    }
    if (cldG) {
	RT_String tmp( 100 );
	RT_PrintObjectNameFunc func( &tmp );
	tmp += '{';
	cldList.doWithElements( &func );
	tmp += '}';
	RT_Object::result( (char*)tmp );
	ret++;
    }
    if (fatherF) {
	// if it is an empty string then delete the father:
	if (!strcmp( fatherV, "" )) { ret ++; father( 0 ); }
	else {
	    RT_Object *obj = RT_Object::getObject( fatherV );
	    if (!obj ) rt_Output->errorVar( get_name(), ": No such object: ", fatherV, "!", 0 );
	    else { father( obj ); ret++; }
	}
    }
    return ret;
}

int RT_InputDevice::onF, RT_InputDevice::offF, RT_InputDevice::onG, 
RT_InputDevice::addCBF, RT_InputDevice::remCBF, RT_InputDevice::fatherF,
RT_InputDevice::fatherG,RT_InputDevice::cldG,RT_InputDevice::camG,
RT_InputDevice::timeG;
char *RT_InputDevice::addCBV, *RT_InputDevice::remCBV, *RT_InputDevice::fatherV;

RT_ParseEntry RT_InputDevice::table[] = {
    {"-on", RTP_NONE, 0, &onF, "Turn the input device on.", ""},
    {"-off", RTP_NONE, 0, &offF, "Turn the input device off.", ""},
    {"-get_on", RTP_NONE, 0, &onG, "Return the current state of the object.", ""},

    {"-father", RTP_STRING, (char*)&fatherV, &fatherF, "Bind the input object to a {ARG 1 Father} object. If you specify an empty string, then delete any connected father. The father object must be a camera or device object.", "OBJECT"},
    {"-get_father", RTP_NONE, 0, &fatherG, "Return the current father object.", ""},
    {"-get_camera", RTP_NONE, 0, &camG, "Return the current camera object.", ""},
    {"-get_children", RTP_NONE, 0, &cldG, "Get the children.", RTPS_NONE },

    {"-get_time", RTP_NONE, 0, &timeG, "Return the time of the last event.", ""},

    {"-addCB", RTP_STRING, (char*)&addCBV, &addCBF, "Add a new {ARG 1 Callback} to the callback list.", "Procedure"},
    {"-removeCB", RTP_STRING, (char *)&remCBV, &remCBF, "Remove a {ARG 1 Callback} from the callback list.", "Procedure"},
    { 0, RTP_END, 0, 0, 0, 0 }
}; 

int RT_InputDevice::addTclCB(char *proc) {
    RT_FindTclCallbackFunctoid func( proc );
    cbList.doWithElements( &func );
    if ( func.get() ) return 0;
    RT_Callback *cb = new RT_TclCallback( proc );
    cbList.append( cb );
    cb->setList( &cbList );
    return 1;
}

int RT_InputDevice::removeTclCB(char *proc) {
    RT_FindTclCallbackFunctoid func( proc );
    cbList.doWithElements( &func );
    RT_Callback *cb = func.get();
    if (!cb) return 0;
    cbList.remove( cb );
    delete cb;
    return 1;
}

class RT_SaveCBFunc: public RT_GeneralListFunctoid {
    void exec(RT_GeneralListEntry *e, void * f) {
	if (e->isA( RTN_CALLBACK )) ((RT_Callback*)e)->printProc((FILE*)f);
    }
};

class RT_SaveCBIFunc: public RT_GeneralListFunctoid {
    char *name; // name of the device
    void exec(RT_GeneralListEntry *e, void * f) {
	if (e->isA( RTN_CALLBACK )) {
	    RT_Callback *cb = (RT_Callback*)e;
	    if (cb->getName()) fprintf( (FILE*)f, "%s -addCB %s\n", name, cb->getName() );
	}
    }
  public:
    RT_SaveCBIFunc(char *_name) { name = _name; }
};

void RT_InputDevice::print(FILE *f) const {
    RT_SaveCBFunc func;
    cbList.doWithElements( &func, f );
    printCon(f);
    fprintf( f, "\n%s %s\n", get_name(), state ? "-on" : "-off" );
    RT_SaveCBIFunc func1( (char*)get_name());
    cbList.doWithElements( &func1, f );
}

void RT_InputDevice::father(RT_Object *obj) {
    if (xfather) {
	if ( (long)obj == -1 ) obj = 0; 
	else {
	    if (xfather->isA( RTN_INPUT_DEVICE )) ((RT_InputDevice *) xfather)->removeChild( this );
	    else if (xfather->isA( RTN_CAMERA )) xfather->removeRelatedObject( this ); 
	}
    }
    else rt_InputServer->removeObject( this );
    // the object was still in the global list

    // reset the father
    xfather = 0;
    
    if (!obj) {
	rt_InputServer->addObject( this );
	// put the object into the global device list
	return;
    }
    
    if (obj->isA( RTN_CAMERA )) {
	xfather = obj;
	RT_Camera *cam = (RT_Camera *)obj;
	cam->addRelatedObject( this );
	addRelatedObject( cam ); 
    } else if (obj->isA( RTN_INPUT_DEVICE )) {
	xfather = obj;
	((RT_InputDevice *) obj)->addChild( this );
    }
    
    if (!xfather) rt_Output->errorVar( get_name(),": Object ", obj->get_name(),
				      " is not a camera nor an input object.", 0 );
}

void RT_InputDevice::objectKilled(RT_Object *a) {
    if (a == xfather) father( (RT_Object*)-1 );
    RT_Object::objectKilled( a ); 
}

void RT_InputDevice::callCBs() {
    class LFunctoid: public RT_GeneralListFunctoid {
      public:
	void exec(RT_GeneralListEntry *e, void *d) {
	    if ( e->isA( RTN_CALLBACK )) ((RT_Callback*)e)->exec( (RT_InputDevice*)d);
	}
    } func;
    cbList.doWithElements( &func, this );
}

void RT_InputDevice::callChildren(RT_Event *ev) {
    class LFunctoid: public RT_GeneralListFunctoid {
      public:
	void exec(RT_GeneralListEntry *dev, void *ev) {
	    if ( dev->isA( RTN_INPUT_DEVICE )) ((RT_InputDevice*)dev)->event((RT_Event*)ev);
	}
    } func;
    cldList.doWithElements( &func, ev );
}

RT_Camera *RT_InputDevice::get_camera() {
    if (xfather) {
	if ( xfather->isA( RTN_CAMERA)) return (RT_Camera *)xfather;
	if ( xfather->isA( RTN_INPUT_DEVICE)) 
	    return ((RT_InputDevice *)xfather)->get_camera();
    } 
    return 0;
}

extern int RT_eval(char*);

int RT_ConsoleInputCB::evalCmd() {
    static char str[1001];
    fgets( str, 1000, stdin ); 

    if (flag) cmd = str;
    else cmd += str;
	
    if ( cmd[ cmd.length() - 1 ] != '\\' )
	flag = Tcl_CommandComplete( (char*)cmd );
    else flag = 0;
    
    if (flag) {
	fprintf( stdout, "%s\n-> ", RT_eval( cmd ) ); fflush( stdout );
    }
    return flag;
}


