#ifndef __USEFUL_MAPP_H__
#define __USEFUL_MAPP_H__

////////////////////////////////////////////////////////////////////////////////
//  Definitions of classes for texture/image mapping to primitives.           //  
//  LAST EDIT: Tue Aug 16 14:26:07 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "mapping.h"
#include "image.h"
#include "texture.h"

void rt_initMappingCommands(Tcl_Interp *);

extern const char *RTN_IMAGE_MAPPING;

class RT_ImageMapping: public RT_Mapping {
    static RT_ParseEntry table[];
    RT_Image *ximage;
    //#### the statics for parameter parsing:
    static int imF, imG; static char *imV;

  public:
    void objectKilled(RT_Object *a) {
	if (a == ximage) image( (RT_Image*)-1 );
	RT_Object::objectKilled( a );
    }

    void smapping( const RT_Primitive *, const RT_Vector &, RT_Surface&);

    //#### the Tcl/C++ methods:
    RT_ImageMapping(char *a = 0): RT_Mapping(a) { ximage = 0; }

    int isA(const char *c) const { return RTM_isA( RTN_IMAGE_MAPPING, c ) || RT_Mapping::isA( c ); }
    const char *get_class() const { return RTN_IMAGE_MAPPING; }
    const char *get_description() const { return "Mapping an image object to a primitive by substituting the ambient and diffuse components. The image area is (0,0) to (1,1). If the primitive returns coordinates lying outside this area the object surface remains unchanged."; }

    void image( RT_Image *img) {
	if (ximage) {
	    if ((long)img == -1) img = 0;
	    else ximage->removeRelatedObject( this );
	}
	ximage = img; 
	if (ximage) {
	    addRelatedObject( ximage );
	    ximage->addRelatedObject( this );
	    if (!ximage->get_width()) ximage->read();
	    // its an empty image - try to let it read a file
	}
    } 
    RT_Image *get_image() const { return ximage; }

    void print(FILE *f) const {
	printCon( f );
	if (ximage) fprintf( f, "%s -image %s\n", get_name(), ximage->get_name() );
    }
    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_TEXTURE_MAPPING;

class RT_TextureMapping: public RT_Mapping {
    static RT_ParseEntry table[];
    //#### the statics for parameter parsing:
    static int txF, txG; static char *txV;
  protected:
    RT_Texture3D *xtext;
  public:
    void objectKilled(RT_Object *a) {
	if (a == xtext) texture( (RT_Texture3D*)-1 );
	RT_Object::objectKilled( a );
    }

    void smapping( const RT_Primitive *, const RT_Vector &, RT_Surface&);
    void nmapping( const RT_Primitive *, const RT_Vector &, RT_Vector&);

    //#### the Tcl/C++ methods:
    RT_TextureMapping(char *a = 0): RT_Mapping(a) { xtext = 0; }

    const char *get_class() const { return RTN_TEXTURE_MAPPING; }
    const char *get_description() const { return "Mapping a 3D texture object to a primitive by substituting/modifying the ambient and diffuse components, and the normal vector."; }
    int isA(const char *c) const { return RTM_isA( RTN_TEXTURE_MAPPING, c ) || RT_Mapping::isA( c ); }

    void texture( RT_Texture3D *);
    RT_Texture3D *get_texture() const { return xtext; }

    void print(FILE *f) const {
	printCon( f );
	if (xtext) fprintf( f, "%s -texture %s\n", get_name(), xtext->get_name() );
    }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

extern const char *RTN_COMPOSITE_TEXTURE_MAPPING;
extern const char *RTSN_CTM;

class RT_CompositeTextureMapping: public RT_TextureMapping {
  public:
    void smapping( const RT_Primitive *, const RT_Vector &, RT_Surface&);
    void nmapping( const RT_Primitive *, const RT_Vector &, RT_Vector&);

    //#### the Tcl/C++ methods:
    RT_CompositeTextureMapping(char *a = 0): RT_TextureMapping(a) {}

    const char *get_class() const { return RTN_COMPOSITE_TEXTURE_MAPPING; }
    const char *get_description() const { return "Mapping a 3D texture object to a primitive by substituting/modifying the ambient and diffuse surface components, and the normal vector by using hierarchically the (grand) fathers modelling coordinates if the object is a part object."; }
    int isA(const char *c) const { return RTM_isA( RTN_COMPOSITE_TEXTURE_MAPPING, c ) || RT_TextureMapping::isA( c ); }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

extern const char *RTN_WORLD_TEXTURE_MAPPING;
extern const char *RTSN_WTM;

class RT_WorldTextureMapping: public RT_TextureMapping {
  public:
    void smapping( const RT_Primitive *, const RT_Vector &, RT_Surface&);
    void nmapping( const RT_Primitive *, const RT_Vector &, RT_Vector&);

    //#### the Tcl/C++ methods:
    RT_WorldTextureMapping(char *a = 0): RT_TextureMapping(a) {}

    const char *get_class() const { return RTN_WORLD_TEXTURE_MAPPING; }
    const char *get_description() const { return "Mapping a 3D texture object to a primitive by substituting/modifying the ambient and diffuse components and using the world coordinates."; }
    int isA(const char *c) const { return RTM_isA( RTN_WORLD_TEXTURE_MAPPING, c ) || RT_TextureMapping::isA( c ); }
    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

#endif
