////////////////////////////////////////////////////////////////////////////////
//  definition of a generic vector class                                      //  
//  LAST EDIT: Fri Feb 10 15:39:57 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __GENVECTOR_H__
#define __GENVECTOR_H__

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <math.h>
#include <stdio.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

class _Vector {
    friend class _Matrix;

    double* v;
    int d;
  
    void check_dimensions(const _Vector&) const;
  public:
    _Vector(); 
    _Vector(int d); 
    _Vector(double a, double b);
    _Vector(double a, double b, double c);
    _Vector(const _Vector&);
    ~_Vector(); 
    _Vector& operator=(const _Vector&);
    
    int    dim()    const { return d; }
    double length() const;

    void newGeometry(int);

    _Vector norm() const { return *this/length(); }
    
    double angle(const _Vector& w) const; 
    double& operator[](int i);
    double  operator[](int) const;
    _Vector& operator+=(const _Vector&);
    _Vector& operator-=(const _Vector&);
    _Vector  operator+(const _Vector& v1) const;
    _Vector  operator-(const _Vector& v1) const;
    double  operator*(const _Vector& v1) const;
    _Vector  operator*(double r) const;
    _Vector  operator-() const;
    _Vector  operator/(double) const;
  
    int operator==(const _Vector&) const;
    int operator!=(const _Vector& w) const { return !(*this == w); }
    int  compare(const _Vector&, const _Vector&);
  
    void print( FILE *) const;
};

#endif




