////////////////////////////////////////////////////////////////////////////////
//  definition of parametric surfaces                                         //  
//  LAST EDIT: Wed Mar  8 08:25:57 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __FORMS_H__
#define __FORMS_H__

#include "quadmesh.h"
#include "bspline.h"

typedef enum RT_SurfaceMode {
    RTE_NORMAL = 0, // default
    RTE_CLOSED_HORIZONTAL,
    RTE_CLOSED_BOTH
};

extern const char *RTN_PARAM_SURFACE;

class RT_ParamSurface: public RT_Quadmesh, public RT_ResolutionAttrImpl {
  private:
    // a reference to resolution class, which will be inherited to all derived classes:
    RT_ResolutionAttribute *xsolution;
    
    // parameter parsing:
    static RT_ParseEntry table[];
    static int contNetF;
  protected:
    // draw the control net or do not:
    int drawNet;

    // references to quadmesh:
    RT_Quadmesh *xmesh;

    // covered for all non derived classes:
    int isA(const char * _c) const {  return RT_Quadmesh::isA( _c ) || RTM_isA(_c, RTN_PARAM_SURFACE ); }
  public:
    RT_ParamSurface( char *a, int b, int c, const RT_Vector *d, const RT_Surface *e = 0, const RT_Vector *f = 0 ) :
    RT_Quadmesh( a, b, c, d, e, f ) {
	xsolution = 0;
	
	// create the father-child relation:
	xmesh = new RT_Quadmesh( 0, 0, 0, 0 );
	xmesh->father( this );
	
	// default values:
	drawNet = 0;
    }
    ~RT_ParamSurface() { if( xmesh ) delete xmesh; }
    
    // Attributes interface
    void checkAttributes();
    void createReferences(const RT_AttributeList &);
    void resolution(double);
    double get_resolution() const;
    
    // shader interface:
    void render() {
	if( ( drawNet ) && !( get_fillstyle() ) ) RT_Quadmesh::render();
	xmesh->RT_Quadmesh::render();
    }
    
    RT_Bounds get_bounds() { return xmesh->get_bounds(); }
    // ray-tracer interface:
    int intersect( const RT_Ray& ray, RT_InterSectionList& list) { return xmesh->RT_Quadmesh::intersect( ray, list ); }
    void normal(const RT_Vector &wc, RT_Vector &n) { xmesh->normal( wc, n ); }
    
    const char *get_description() const { return "An editable parametrical surface"; }
    const char *get_class() const { return RTN_PARAM_SURFACE; }
    
    int copy(RT_Primitive *) const;

    int objectCMD( char *argv[] );
};

extern const char *RTN_SPLINE_SURFACE;

class RT_SplineSurface: public RT_ParamSurface { 
  private:
    // create a b-spline surface:
    void create() { computeSurface(); }
    
    // parameter parsing:
    static RT_ParseEntry table[];
    static int getOrdF, smodeF, smodeV, getsModeF;
    
    // reference to a b-spline:    
    _bspline *uspline;
    _bspline *wspline;
    
    RT_SurfaceMode surfMod;
 
    void computeSurface();
  public:
    RT_SplineSurface ();
    RT_SplineSurface( char*, int, int, const RT_Vector*, const RT_Surface*, const RT_Vector*);

    ~RT_SplineSurface() {
	if( uspline ) delete uspline;
	if( wspline ) delete wspline;
    }
    
    const int getSurfMod() const { return (int)surfMod; }
    
    void setSurfMod( RT_SurfaceMode val ) {
	switch( val ) {
	  case RTE_NORMAL:
	    uspline->setMod( _OPEN );
	    wspline->setMod( _OPEN );
	    break;
	  case RTE_CLOSED_HORIZONTAL:
	    uspline->setMod( _CLOSED );
	    wspline->setMod( _OPEN );
	    break;
	  case RTE_CLOSED_BOTH:
	    uspline->setMod( _CLOSED );
	    wspline->setMod( _CLOSED );
	    break;
	}
	surfMod = val;
	geomChanged();
    }
    void setOrder( int val1, int val2 ) {
	uspline->setOrd(val1);
	wspline->setOrd(val2);
	geomChanged();
    }
    int getOrdU() const {
	return uspline->getOrd();
    }
    int getOrdW() const {
	return wspline->getOrd();
    }
    void print ( FILE *f ) const {
	RT_ParamSurface::print( f );
	fprintf( f, "%s -order %d %d ", get_name(), getOrdU(), getOrdW() );
	fprintf( f, "-mode %d ", getSurfMod() );
	fprintf( f, "\n" );
    }

    const char *get_description() const { return "An editable b-spline surface of order = 3 in both directions"; }
    const char *get_class() const { return RTN_SPLINE_SURFACE; }
    int isA(const char * _c) const {  return RT_ParamSurface::isA( _c ) || RTM_isA(_c, RTN_SPLINE_SURFACE ); }
    
    static int classCMD( ClientData, Tcl_Interp *, int, char *[] );
    int objectCMD( char *argv[] );
};

#endif










