////////////////////////////////////////////////////////////////////////////////
//  implementation of parametric surfaces                                     //  
//  LAST EDIT: Wed Mar  8 08:52:48 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#include "forms.h"

const char *RTN_PARAM_SURFACE = "ParamSurface";

int RT_ParamSurface::contNetF;

RT_ParseEntry RT_ParamSurface::table[] = {
    { "-controlNet", RTP_NONE, 0, &contNetF, "Draw the control net of the surface.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

RT_ParamSurface::objectCMD( char *argv[] ) {
   int ret = RT_Quadmesh::objectCMD( argv );
   RT_parseTable( argv, table );
   if( contNetF ) {
       if( drawNet )
	   drawNet = 0;
       else
	   drawNet = 1;
       geomChanged();
       ret++;
   } 
   return ret;
}
     
void RT_ParamSurface::checkAttributes() {
    RT_Quadmesh::checkAttributes();
    //if (xsolution->isChanged()) geomChanged();
    if (xsolution->isChanged() || 
	get_attribute( RTN_SURFACE_ATTR ).isChanged() ||
	get_attribute( RTN_FILLSTYLE_ATTR ).isChanged() )
	geomChanged();
}

void RT_ParamSurface::createReferences( const RT_AttributeList &list ) {
    RT_Quadmesh::createReferences( list );
    
    // create a resolution reference:
    RT_ResolutionAttribute *tmp = xsolution;
    xsolution = (RT_ResolutionAttribute*)list.retraverse( RTN_RESOLUTION_ATTR, this );
    //if ( (tmp != xsolution) || (*tmp != *xsolution ) ) geomChanged();
    
    // create a surface reference:
    RT_SurfaceAttribute *tmp1 =
	(RT_SurfaceAttribute*)attributes->get( RTN_SURFACE_ATTR );
    RT_SurfaceAttribute *tmp2 =
	(RT_SurfaceAttribute*)list.retraverse( RTN_SURFACE_ATTR, this );
    
    //if( (tmp1 != tmp2) || (*tmp1 != *tmp2) ) geomChanged();
    
    // a fillstyle reference:
    RT_FillstyleAttribute *tmp3 =
	(RT_FillstyleAttribute*)attributes->get( RTN_FILLSTYLE_ATTR );
    RT_FillstyleAttribute *tmp4 = 
	(RT_FillstyleAttribute*)list.retraverse( RTN_FILLSTYLE_ATTR, this );
    
    if ( ( (tmp != xsolution) || (*tmp != *xsolution ) ) || 
	( (tmp3 != tmp4) || (*tmp3 != *tmp4) ) || 
	( (tmp1 != tmp2) || (*tmp1 != *tmp2) ) )
	geomChanged();
}

void RT_ParamSurface::resolution( double s ) {
    xsolution = (RT_ResolutionAttribute*)attributes->get( RTN_RESOLUTION_ATTR );
    if (!xsolution) 
	attributes->insert( xsolution = new RT_ResolutionAttribute);
    xsolution->resolution( s );
    geomChanged();
}

double RT_ParamSurface::get_resolution() const {
    return xsolution->get_resolution();
}

int RT_ParamSurface::copy(RT_Primitive *p) const {
    // copy into parametric surface here!!!

    if (p->isA( RTN_QUADMESH)) {
	if (!xmesh->get_x()) {
	    rt_Output->errorVar( get_name(), ": First update the parametric surface, then copy again.", 0 );
	    return(0);
	}
	return xmesh->copy( p );
    }

    return( RT_Primitive::copy(p) );
}

const char *RTN_SPLINE_SURFACE = "SplineSurface";

int RT_SplineSurface::getOrdF;
int RT_SplineSurface::smodeF, RT_SplineSurface::smodeV, RT_SplineSurface::getsModeF;

RT_ParseEntry RT_SplineSurface::table[] = {
    {"-order",  RTP_SPECIAL, 0, 0, "Change the order of the b-spline surface in u {ARG 1} and w direction.", "Integer, Integer" },
    {"-get_order", RTP_NONE, 0, &getOrdF, "Get current order of the b-spline surface in the u and w direction.", RTPS_NONE },
    {"-mode", RTP_INTEGER, (char*)&smodeV, &smodeF, "Set the surface {ARG 1} mode: 0 - normal, 1 - closed in horizontal direction, 2 - closed in both directions.", RTPS_INTEGER },
    {"-get_mode", RTP_NONE, 0, &getsModeF, "Get current mode of the surface.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 },
};

int RT_SplineSurface::objectCMD( char *argv[]) {
    int ret = RT_ParamSurface::objectCMD( argv );
    RT_parseTable( argv, table );
    if (smodeF) {
	setSurfMod( (RT_SurfaceMode)smodeV );
	ret++;
    }
    if (getsModeF) {
	static char tmp[5]; ret++;
	RT_int2string( getSurfMod(), tmp );
	RT_Object::result( tmp );
    }
    if (getOrdF) {
	static char tmp1[3]; static char tmp2[3]; static char tmp[8]; ret++;
	RT_int2string( getOrdU(),tmp1 );
	RT_int2string( getOrdW(),tmp2 );
	sprintf( tmp,"%s %s",tmp1,tmp2 );
	RT_Object::result( tmp );
    }
    {
	int start, diff1 = 0, diff2 = 0;
	int ordU, ordW;
	if ((start = RT_findString( argv, "-order" )) >= 0) {
	    if ( RT_getInt( &argv[ start + 1 ], ordU, diff1) ) {
		if ( RT_getInt( &argv[ start + 2 ], ordW, diff2) ) {
		    setOrder(ordU,ordW);
		    ret++;
		}
	    }
	}
	RT_clearArgv( argv, start, diff1 + diff2 );
    }
    return ret;
}

int RT_SplineSurface::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res = _classCMD( cd, ip, argc, argv );
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", argv[0], " { String Integer Integer Vector_List Surface_List Vector_List} {  Creates a new editable spline surface. Arguments are: the {ARG 1 Name} of the new object, number of {ARG 2 Rows}, number of {ARG 3 Columns}, list of {ARG 4 Points}, list of {ARG 5 Surfaces} and the list of {ARG 6 Normals}.}}", 0 );
	return TCL_OK;
    }
    if (res == TCL_OK) { 
	if (argc != 7) { Tcl_AppendResult( ip, "Bad number of arguments. Try \"", RTN_SPLINE_SURFACE, " ?\".", 0 ); return TCL_ERROR; }
	int x; 
	if ( !RT_string2int( argv[2], x)) { Tcl_AppendResult( ip, "Arg 2 should be an integer.", 0 ); return TCL_ERROR; }
	if ( x <= 0 ) { Tcl_AppendResult( ip, "X dimension should be a positive number!.", 0 ); return TCL_ERROR; }
	int y;
	if ( !RT_string2int( argv[3], y)) { Tcl_AppendResult( ip, "Arg 3 should be an integer.", 0 ); return TCL_ERROR; }
	if ( y <= 0 ) { Tcl_AppendResult( ip, "Y dimension should be a positive number!.", 0 ); return TCL_ERROR; }
	
	int nr = x * y;
	RT_Vector  *vecs = new RT_Vector[nr];
	RT_Surface *surfs = 0;
	RT_Vector *norms = 0;
	
	// initialize points
	for (int i = 0; i < nr; i++) vecs[i] = RT_NULL_NORMAL; 
	
	int xargc; char **xargv; int dum, cnt;
	int ret = TCL_ERROR;
	if (Tcl_SplitList( ip, argv[4], &xargc, &xargv) == TCL_OK) {
	    if (xargc < nr) rt_Output->warningVar( argv[0], ": not enough vertices specified. Using defaults!", 0);
	    cnt = xargc < nr ? xargc : nr;
	    for ( i = 0; i < cnt; i++) 
		if (!RT_getVector( &xargv[i], vecs[i], dum)) 
		    rt_Output->warningVar( argv[0], ": found a bad point value. Using default value!", 0);
	    free((char*)xargv);
	    
	    if (Tcl_SplitList( ip, argv[5], &xargc, &xargv) == TCL_OK) {
		surfs = new RT_Surface[nr];	
		// initialize surfaces:
		for ( i = 0; i < nr; i++) surfs[i] = RT_NULL_SURFACE;
		if (xargc < nr && xargc) rt_Output->warningVar( argv[0], ": not enough surfaces specified. Using defaults!", 0);
		cnt = xargc < nr ? xargc : nr;
		for ( i = 0; i < cnt; i++) 
		    if (strlen( xargv[i]) && !RT_getSurface( &xargv[i], surfs[i], dum)) 
			rt_Output->warningVar( argv[0], ": found a bad surface value. Using default value!", 0);
		free((char*)xargv);
	    }
	    
	    if (Tcl_SplitList( ip, argv[6], &xargc, &xargv) == TCL_OK) {
		norms = new RT_Vector[nr];
		// initialize normals:
		for ( i = 0; i < nr; i++) norms[i] = RT_NULL_NORMAL;
		if (xargc < nr && xargc) rt_Output->warningVar( argv[0], ": not enough normals specified. Using defaults!", 0);
		cnt = xargc < nr ? xargc : nr;
		for ( i = 0; i < cnt; i++) if (strlen( xargv[i]) && !RT_getVector( &xargv[i], norms[i], dum)) 
		    rt_Output->warningVar( argv[0], ": found a bad normal value. Using default value!", 0);
		free((char*)xargv);
	    }
	    new RT_SplineSurface( argv[1], x, y, vecs, surfs, norms );
	    RTM_classReturn;
	}
	else rt_Output->errorVar( argv[0], ": Could not create a surface! No vertices found.", 0);
	delete [] vecs; if (surfs) delete [] surfs; if (norms) delete [] norms;
	return ret;
    }
    return res;
}

RT_SplineSurface::RT_SplineSurface() :
RT_ParamSurface(0,0,0,0,0) {
    uspline = new _bspline;
    wspline = new _bspline;
}

RT_SplineSurface::RT_SplineSurface( char*a, int b, int c, const RT_Vector*d, const RT_Surface*e, const RT_Vector*f) :
RT_ParamSurface( a, b, c, d, e, f ) {
    int x = get_x(), y = get_y(); 
    uspline = new _bspline
	(x, x >= 3 ? 3 : x, (int)( (30 - x) * 0.2 + x), _OPEN );
    wspline = new _bspline
	(y, y >= 3 ? 3 : y, (int)( (30 - y) * 0.2 + y), _OPEN );
}

void RT_SplineSurface::computeSurface() {
    // get dimensions of the control net:
    int m = get_x(); int n = get_y();

    // compute the limits for the evaluation loops:
    int dimx = (int)( (30 - m) * get_resolution() + m ) ;
    int dimy = (int)( (30 - n) * get_resolution() + n );

    // check dimensions:
    if( ( !(uspline->getNum() == m) || !(uspline->getDim() == dimx) ) ) {
	uspline->setNum(m);
	uspline->setDim(dimx);
    }
    
    if( ( !(wspline->getNum() == n) || !(wspline->getDim() == dimy) ) ) {
	wspline->setNum(n);
	wspline->setDim(dimy);
    }

    uspline->update();
    wspline->update();
    
    // delete the old surface:
    xmesh->newGeometry( dimx, dimy );
    
    // matrices of the base functions in each direction:
    _Matrix Nu,Nw;
    Nu = uspline->getBase();
    Nw = wspline->getBase();
    
    // some temprary helps:
    int uCountTo = Nu.Cols();
    int wCountTo = Nw.Cols();
    
    int uModDiv = uspline->getNum();
    int wModDiv = wspline->getNum();
    
    int i,j,u,w,fillFlag = get_fillstyle();
    
    // structures to keep the vertices' values:
    RT_Surface s,sf;
    RT_Vector v,vc;
    for ( u = 0; u < Nu.Rows(); u++ ) {
	for( w = 0; w < Nw.Rows(); w++ ) {
	    // reset values:
	    vc.x = vc.y = vc.z = 0;
	    
	    if (fillFlag) {
		sf.tran = sf.refr = sf.shin = 0;
		sf.ambi.r = sf.ambi.g = sf.ambi.b = 0;
		sf.diff.r = sf.diff.g = sf.diff.b = 0;
		sf.emmi.r = sf.emmi.g = sf.emmi.b = 0;
		sf.spec.r = sf.spec.g = sf.spec.b = 0;
	    }
	    // compute point on the surface:
	    for( i = 0; i < uCountTo; i++ ) {
		for( j = 0; j < wCountTo; j++ ) {
		    v = get_vtPoint(i%uModDiv, j%wModDiv);
		    
		    vc.x = vc.x + Nu(u,i)*Nw(w,j)*v.x;
		    vc.y = vc.y + Nu(u,i)*Nw(w,j)*v.y;
		    vc.z = vc.z + Nu(u,i)*Nw(w,j)*v.z;
		    
		    if ( fillFlag ) {
			s = get_vtSurface(i%uModDiv, j%wModDiv);
			
			sf.ambi.r = sf.ambi.r + Nu(u,i)*Nw(w,j)*s.ambi.r;
			sf.ambi.g = sf.ambi.g + Nu(u,i)*Nw(w,j)*s.ambi.g;
			sf.ambi.b = sf.ambi.b + Nu(u,i)*Nw(w,j)*s.ambi.b;
			
			sf.diff.r = sf.diff.r + Nu(u,i)*Nw(w,j)*s.diff.r,
			sf.diff.g = sf.diff.g + Nu(u,i)*Nw(w,j)*s.diff.g;
			sf.diff.b = sf.diff.b + Nu(u,i)*Nw(w,j)*s.diff.b;
			
			sf.emmi.r = sf.emmi.r + Nu(u,i)*Nw(w,j)*s.emmi.r;
			sf.emmi.g = sf.emmi.g + Nu(u,i)*Nw(w,j)*s.emmi.g;
			sf.emmi.b = sf.emmi.b + Nu(u,i)*Nw(w,j)*s.emmi.b;
			
			sf.spec.r = sf.spec.r + Nu(u,i)*Nw(w,j)*s.spec.r;
			sf.spec.g = sf.spec.g + Nu(u,i)*Nw(w,j)*s.spec.g;
			sf.spec.b = sf.spec.b + Nu(u,i)*Nw(w,j)*s.spec.b;
			
			sf.tran = sf.tran + Nu(u,i)*Nw(w,j)*s.tran;
			sf.refr = sf.refr + Nu(u,i)*Nw(w,j)*s.refr;
			sf.shin = sf.shin + Nu(u,i)*Nw(w,j)*s.shin;
		    }
		}
	    }
	    // insert the new vertex:
	    xmesh->vtPoint(u, w, vc);
	    if( fillFlag )
		xmesh->vtSurface(u, w, sf);
	}
    }
    if ( fillFlag ) xmesh->computeNormals();
    // compute normals of b-spline surface:
}






