////////////////////////////////////////////////////////////////////////////////
//  Implementaion of scientific base class.                                   //  
//  LAST EDIT: Thu Aug 11 14:13:05 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//                      yart@prakinf.tu-ilmenau.de                            //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <scient/2d_lat.h>

#define EPSILON 0.00000001

void RT_2DLattice::delete_cmap() {
// The quadmesh becomes black
    int i,j;
    RT_Surface dummy;
    for ( i=0; i<dims[1]; i++ ) {
	for ( j=0; j<dims[0]; j++ ) {
	    quadmesh.vtSurface( i, j, dummy );
	}
    }
}

void RT_2DLattice::cmap( int pnr, double hue_min, double hue_max, double sat, double val ) {
// The parameters are linear mapped to the specified color space
    int i, j, co[2];
    double pmin, pmax;
    pmin = paramData[pnr].Pmin;
    pmax = paramData[pnr].Pmax;
    RT_Surface sf;

    if ( (!pnr) || (!paramData[pnr].loaded) ) {
	delete_cmap();
	return;
    }

    if ( pmax - pmin < EPSILON ) {
	rt_Output->warningVar( get_name(), ": No different parameters given. Color mapping of parameters not possible. ", 0 );
	delete_cmap();
	return;
    }
    double hue_ratio = (hue_max - hue_min) / (pmax - pmin);
    double hsl[3];
    hsl[1] = sat;
    hsl[2] = val;
    double pm;
    RT_Color col = RT_Color();
    for ( i=0; i<dims[1]; i++ ) {
	for ( j=0; j<dims[0]; j++ ) {
	    getParameter( pnr, j, i, &pm );
	    hsl[0] = hue_ratio * ( pm - pmin ) + hue_min;
	    col.setHSL( hsl );
	    sf.emmi = col;
	    sf.diff = col;
	    sf.ambi = col;
	    quadmesh.vtSurface( i, j, sf );
	}
    }
}
