#ifndef SCANNER_H
#define SCANNER_H

#include <sys/types.h>

typedef enum { EMPTY, STRING, FLOAT, INT, OPERATOR, IDENT, LOCATION, EEK } Type;

typedef enum { PLUS, MINUS, MUL, DIV, OP, CP, COMMA, LT, LE, GE, GT, EQ, NE, POW } Operator;

typedef struct
{
  Type type;
  union
  {
    char *string;
    double flt;
    long integer;
    Operator operator;
    char *ident;
    int location[3];
    char *err;
  } u;
} Token;

Token **scan(const char **s);
void print(char *s, size_t size, int star, int quote, int scientific, int precision, Token **n);

#endif
/*{{{}}}*/
