#ifndef DISPLAY_H
#define DISPLAY_H

/* Solaris needs termios.h to be included or NCC will not be defined :( */
#include <termios.h>
#include <sys/types.h>
#include <curses.h>

#include "sheet.h"

typedef struct
{
  chtype c;
  char *str;
} MenuChoice;

void adjust(Adjust a, char *s, size_t n);
void redraw(void);
void redraw_sheet(Sheet *sheet);
int line_edit(Sheet *sheet, char *buf, size_t size, WINDOW *w, const char *prompt, size_t *x, size_t *offx);
int line_numedit(int *n, WINDOW *w, const char *prompt, size_t *x, size_t *offx);
int line_idedit(char *ident, size_t size, WINDOW *w, const char *prompt, size_t *x, size_t *offx);
int line_menu(WINDOW *w, const char *prompt, const MenuChoice *choice, int curx);
int line_ok(WINDOW *w, const char *prompt, int curx);
void line_msg(WINDOW *w, const char *prompt, const char *msg);

#endif
/*{{{}}}*/
