#!/usr/local/bin/perl
#  common.pl - common routines shared by many files
#
#  Written by Curtis Olson.  Started August 22, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: common.pl,v 1.3 1995/02/23 05:08:43 curt Exp $
# (Log is kept at end of this file)


# Contributed by Christopher Browne, Oct. 24/94
sub pad { 
    return sprintf("%02d", @_[0]); 
}


# return the directory of a file name 
sub file_dirname {
    local($file) = @_;
    local($pos);

    $pos = rindex($file, "/");
    if ( $pos >= 0 ) {
	return substr($file, 0, ($pos + 1));
    } else {
	return "./";
    }
}


# return the base file name
sub file_basename {
    local($file) = @_;
    local($pos);

    $pos = rindex($file, "/");
    return substr($file, ($pos + 1));
}


# return current date in a nice format
sub nice_date {
    local($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = 
        localtime(time);
    return &pad($mon+1) . "/" . &pad($mday) . "/" . &pad($year);
}


# return current date in a raw format
sub raw_date {
    local($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = 
        localtime(time);
    return "19". &pad($year) . &pad($mon+1) . &pad($mday);
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: common.pl,v $
# Revision 1.3  1995/02/23  05:08:43  curt
# Removed dependencies on tclX.
#
# Revision 1.2  1994/11/01  22:39:01  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
# Revision 1.1  1994/10/31  15:18:51  curt
# These files resulted from the splitting of engine.pl
#
