/*-
 * Copyright (c) 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 * Copyright (c) 1994, 1995
 *	Keith Bostic.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)sex_screen.h	9.8 (Berkeley) 2/2/95
 */

typedef struct _sex_private {
/* INITIALIZED AT SCREEN CREATE. */

/* PARTIALLY OR COMPLETELY COPIED FROM PREVIOUS SCREEN. */
#ifndef SYSV_CURSES
	char	*SE, *SO;	/* Inverse video termcap strings. */
#endif
	char	*CE;		/* Clear to EOL termcap string. */
	char	*CM;		/* Cursor movement termcap string. */
	char	*UP;		/* Cursor up termcap string. */
	int	 term_init;	/* Termcap initialized. */
} SEX_PRIVATE;

#define	SXP(sp)		((SEX_PRIVATE *)((sp)->sex_private))

/* Generic interfaces to the ex screen. */
int	sex_optchange __P((SCR *, int));
int	sex_screen_copy __P((SCR *, SCR *));
int	sex_screen_edit __P((SCR *));
int	sex_screen_end __P((SCR *));

/*
 * Sex termcap actions.
 *
 *	EX_TERM_CE	Clear to end-of-line.
 *	EX_TERM_SCROLL	Cursor up plus clear to end-of-line.
 */
enum termact { EX_TERM_CE, EX_TERM_SCROLL };
void	sex_termcap __P((SCR *, enum termact));

/* Sex function prototypes. */
int	sex_bell __P((SCR *));
int	sex_busy __P((SCR *, char const *));
conf_t	sex_confirm __P((SCR *, MARK *, MARK *));
input_t	sex_get __P((SCR *, TEXTH *, ARG_CHAR_T, u_int));
input_t	sex_key_read __P((SCR *, int *, u_int, struct timeval *));
int	sex_refresh __P((SCR *));
int	sex_screen_copy __P((SCR *, SCR *));
int	sex_screen_edit __P((SCR *));
int	sex_screen_end __P((SCR *));
int	sex_screen_exrc __P((SCR *));
int	sex_screen_icmd __P((SCR *, char *));
int	sex_suspend __P((SCR *));
void	sex_terminit __P((SCR *));
int	sex_tsetup __P((SCR *, struct termios *));
int	sex_tteardown __P((SCR *, struct termios *));
