/*
 * These functions were contributed by Byrial Jensen.  They are useful with
 *  Caps lock and non-English languages.
 *
 *
 */

/* Editor:      TDE, the Thomson-Davis Editor
 * Filename:    capslock.c
 * Compiled by: Byrial Jensen
 *
 * This file contains changed duplicates of existing functions, and
 * new functions.
 * The changes have the purpose to better allow creation of
 * non English versions of the editor.
 * This file contains all changes relating to the new editor
 * functions IfCapsLock and IfNotCapsLock.
 */


#include "tdestr.h"
#include "common.h"
#include "define.h"
#include "tdefunc.h"


/*
 * Name:    capslock_active   (NEW FUNCTION)
 * Purpose: To find out if Caps Lock is active
 * Date:    September 1, 1993
 * Author:  Byrial Jensen
 * Returns: Non zero if Caps Lock is actice,
 *          Zero if Caps Lock is not actice.
 * Note:    The function reads directly the BIOS variable
 *          at address 0040h:0017h bit 6
 */
int  capslock_active( void )
{
#if defined( __UNIX__ )
   return( 0 );
#else
   return( (int)( *((unsigned char far *)0x00400017L) & 0x40 ) );
#endif
}


/*
 * Name:    nothing     (NEW FUNCTION)
 * Purpose: Does nothing
 * Date:    September 2, 1992
 * Author:  Byrial Jensen
 * Passed:  arg_filler:  argument to satify function prototype
 * Returns: OK.
 * Notes:   Called for editor functions IfCapsLock and IfNotCapsLock
 */
int  nothing( TDE_WIN *arg_filler )
{
   return( OK );
}
