% run compiler in a subshell and parse error messages
% The file compile.dat is a database for various compilers.  Set the
% string 'compile_parse_error_function' to the approriate compiler.
% This file reads the function from compile.dat.

!if (is_defined ("compile_parse_error_function"))
{
   error ("The variable 'compiler_parse_error_function' is not set.");
}


% this function pulls the correct function out of the compile.dat file
. (
.   [type] =type
.   [ret] 0 =ret
  
.   "compile.dat" find_jedlib_file
.     { "compile.dat file not found!" error} !if

.   widen bob
.   "%@" type strcat bol_fsearch
.      {
.         push_mark   
. 	"--------" bol_fsearch {1 go_up}{eob} else
. 	narrow
.         evalbuffer
. 	1 =ret
.      } if
.    whatbuf delbuf
.    widen
.    ret
. ) compile_select_compiler

. compile_parse_error_function compile_select_compiler
. { "Compiler type not in database!." error } !if

. "compile_parse_errors"    "^X'"   setkey

. (
.    [obuf] "*shell-output*" =obuf
.    [cbuf istr file] whatbuf =cbuf
.    obuf pop2buf
   
.    eol eobp {"No more errors!" message} if
.    {eol eobp not}
.    {
       %bol push_mark eol 1 right pop del_region
.        compile_is_this_line_error
.          {
. 	   =file
. 	   =istr  "Line " istr strcat message
. 	   istr strlen {return} !if
. 	   file find_file pop
. 	   whatbuf =cbuf
. 	   istr integer goto_line
. 	   bol skip_white
. 	   obuf sw2buf
. 	   break
. 	 } if
.        1 down pop
.    } while
   %1 recenter
.    1 down pop
.    cbuf pop2buf
. ) compile_parse_errors

. (
.    [b] whatbuf =b
.    "save_buffers" call
.    do_shell_cmd bob % "\n" insert  % so we can assume the top line is junk
.    b pop2buf
.    compile_parse_errors
. ) compile

#ifdef 0
%  This dumps the compile.dat file in a form which get_doc_string
. can get.
. ("\n" insert) newline

. (
.   [c buf cbuf] "*compile.dat*" =buf whatbuf =cbuf
.   "%@" fsearch {0 return} !if
.   3 right pop
  
.   buf setbuf eob bolp {newline} !if "C" insert
.   cbuf setbuf
  
.   push_mark eol trim buf copy_region
  
  
.   { 1 down }
.   {
.      bol skip_white ";" looking_at eolp or {continue} if
.      push_spot
.      buf setbuf 1 char insert cbuf setbuf
.      push_mark eol trim buf copy_region
.      pop_spot ")" looking_at {break} if
.   } while
. 1
. ) test

#endif
