;;; fvwm-mode.el -- fvwm mode and the font lock configurations

;; Maintainer: David Konerding (rafael@cse.ucsc.edu)

;;; Commentary:

;; This package is a major mode for editing fvwm configuration files and
;; also defines font-lock keywords for fvwm configuration files

;; Any file called ".fvwmrc" or ending in ".fvwm" will enter fvwm-mode.
;; The current font-lock keywords are (and they don't always seem to
;; work right):

;; any word of upper or lower case letters at the start of a line
;; followed by whitespace gets colored using
;; font-lock-function-name-face.

;; any word of upper or lower case letters at the start of a line
;; followed by a "(" (IE, an m4 macro) gets colored using
;; font-lock-comment-face

;; Put this in your .emacs :
;;
;;(setq auto-mode-alist
;;      (append '(("\\.fvwm$" . fvwm-mode)
;;  		(".fvwmrc$" . fvwm-mode)) 
;;	      auto-mode-alist))
;;
;;(autoload 'fvwm-mode "fvwm-mode"
;;  "Mode for editing fvwm config files")
;;
;;(add-hook 'fvwm-mode-hook
;;	  '(lambda ()
;;	     (font-lock-mode t)
;;	     (setq font-lock-keywords fvwm-font-lock-keywords)
;;           (font-lock-fontify-buffer)))
;;


;;; Code:


(defvar fvwm-mode-hook nil
  "Hook to be run when mode is entered")


(defvar font-lock-m4-face 'default
  "new face for m4 macros")

(condition-case nil 
    (progn
      (copy-face 'default   'm4-face)
      (set-face-foreground  'm4-face "blue")
      (set-face-background  'm4-face "white")
      (setq font-lock-m4-face 'm4-face))
  (error nil))

(defvar fvwm-font-lock-keywords 
  '(("^[A-Za-z]+[ \n\t]" . font-lock-function-name-face)
    ("^#.*" . font-lock-comment-face)
    ("^[A-Za-z]+(.*)" . font-lock-m4-face))
  "default font-lock keywords")

(defun fvwm-mode ()
  "Major mode for editing fvwm config files"
  (interactive)
  (kill-all-local-variables)
  (setq mode-name "Fvwm")
  (setq major-mode 'fvwm-mode)
  (run-hooks 'fvwm-mode-hook))

