#
# Toplevel window module
#

# Given a widget, w, returns the toplevel window containing w.
proc th_toplevel {w} {
  while {[lsearch {Toplevel Tk} [winfo class $w]] == -1} {
    set w [winfo parent $w]
  }
  return $w
}

# Given a toplevel widget, alters the nth item in [wm geometry .] by inc.
# value is a new value to use
# So, for n 0=width 1=height 2=xoffset 3=yoffset
proc th_geometry_change {t n value} {
    scan [wm geometry $t] "%dx%d+%d+%d" i(0) i(1) i(2) i(3)
    wm minsize $t 1 1
    set i($n) $value
    wm geometry $t "$i(0)x$i(1)+$i(2)+$i(3)"
}

# Given a toplevel widget, alters the nth item in [wm geometry .] by inc.
# inc is "+ x" or "- x" for some x > 0
# So, for n 0=width 1=height 2=xoffset 3=yoffset
proc th_geometry_adjust {t n {inc +1}} {
    scan [wm geometry $t] "%dx%d+%d+%d" i(0) i(1) i(2) i(3)
    wm minsize $t 1 1
    incr i($n) $inc
    wm geometry $t "$i(0)x$i(1)+$i(2)+$i(3)"
}
