#
# Brings up a menu for tags in Text widgets
#


# Fills menu with the tags in w
proc th_Text_make_tags_menu {w menu} {
# Destroy old submenus and remove all elements in menu.
  set l [$menu index last]
  for {set i 0} {$i < $l} {incr i} {
    set sub [string tolower [lindex [$menu entryconfigure $i -label] 4]]
    catch {destroy $menu.$sub}
  }
  catch {$menu delete 0 last}

# Now add elements in menu, allow elements to be added in submenus.
  global TH
  set tag_flag 1
  foreach tag [$w tag names] {
    if {!$TH(Tag,Empty) && [catch {$w index $tag.first}]} {continue}
    set tag_flag 0
    set submenu $menu.[string tolower $tag]
    $menu add cascade -label "$tag" -menu $submenu \
	-command "th_Text_make_tag_ranges_menu $w $tag $submenu"
    catch {menu $submenu}
  }
  if $tag_flag {$menu add command -label "(None)"
}}


# Fills menu with the tag ranges of tag,
# If ranges are specified, uses those as tag range (args can be a subset of the
# ranges
proc th_Text_make_tag_ranges_menu {w tag menu args} {
  global TH
  set count 0
  catch {$menu delete 0 last}
  set begin_flag 1
  if {$args != ""} {set ranges $args
  } elseif {[set ranges [$w tag ranges $tag]] == ""} {
    $menu add command -label "(None)"
    return
  }
  if {$TH(Tag,Entries,Max) > 0} {
    set stop [expr $TH(Tag,Entries,Max) * 2]
    if {[llength $ranges] > $stop} {
      set rest [lrange $ranges $stop end]
      set ranges [lrange $ranges 0 [expr $stop - 1]]
      catch "menu $menu.more"
      $menu add cascade -label "More..." -menu $menu.more -command "th_Text_make_tag_ranges_menu $w $tag $menu.more $rest"
  }}

  foreach index $ranges {
    if $begin_flag {set begin_index $index ; set begin_flag 0 ; continue}

    set begin_flag 1 ; set end_index $index
    set text [string trim [$w get $begin_index $end_index] "\n"]
    if {([string length $text] < $TH(Tag,Menu,Length)) && \
	([string first "\n" $text] == -1)} {
      set begin_text $text ; set end_text $text
    } else {
      set begin_text [string range $text 0 $TH(Tag,Menu,Length)]
      if {[set break [string first "\n" $begin_text]] > 0} {
        incr break -1
        set tmp $begin_text ; set text [string range $tmp 0 $break]
      }
      append begin_text "..."

      set end_text [string range $text [expr [string length $text] - \
			$TH(Tag,Menu,Length)] end]
      if {[set break [string last "\n" $end_text]] >= 0} {
        incr break
        set tmp $end_text ; set end_text [string range $tmp $break end]
      }
      set tmp $end_text ; set end_text "...$tmp"
    }
    if {[expr $TH(Tag,Start) + $TH(Tag,End)] != 1} {
      append end_text "<" ; set tmp $begin_text ; set begin_text ">$tmp"
    }
    if $TH(Tag,Start) {
      $menu add command -label $begin_text -command \
		"th_Text_goto $w $begin_index 0"}
    if $TH(Tag,End) {
      $menu add command -label $end_text -command \
		"th_Text_goto $w $end_index 0"}
}}


