#
# Widget resizing module
#

# Option is something like "-length" or "-height"
# If option is "-gx", the width of -geometry is changed, if it is '-gy"
# the height of -geometry is changed.
# inc is "+ n" or "- n" for some n > 0.
proc th_resize_widget {w option {inc "+ 1"}} {
  switch -- $option {
    "-gx" {
    scan [lindex [$w configure -geometry] 4] "%dx%d" width height
    if {$width == ""} {set width 0}
    set value [eval expr $width $inc]
    if {$value < 0} {set value 0}
    append value "x$height"
    $w configure -geometry $value
  } "-gy" {
    scan [lindex [$w configure -geometry] 4] "%dx%d" width height
    if {$height == ""} {set height 0}
    set value [eval expr $height $inc]
    if {$value < 0} {set value 0}
    set result $width ; append result "x$value"
    $w configure -geometry $result
  } default {
    set value [eval expr [lindex [$w configure $option] 4] $inc]
    if {$value < 0} {set value 0}
    $w configure $option $value
}}}


