#
# Operations for HTML manipulation in Text widgets.
#

# Returns the beginning of the current anchor
proc th_anchor_begin {w index} {
  global TH
  if {[catch {set case $TH(Search,Case,$w)}]} {set case 0}
  set TH(Search,Case,$w) 1
  set i [th_Text_string_last $w "<a " "$index +4c"]
  set TH(Search,Case,$w) $case
  return $i
}

# Returns the end of the current anchor
proc th_anchor_end {w index} {
  global TH
  if {[catch {set case $TH(Search,Case,$w)}]} {set case 0}
  set TH(Search,Case,$w) 1
  set i [th_Text_string_first $w "</a>" "$index -4c"]
  set TH(Search,Case,$w) $case
  if {$i == ""} {return ""} else {return "$i +4c"}
}

# Returns the beginning of the next anchor
proc th_anchor_next {w index} {
  global TH
  if {[catch {set case $TH(Search,Case,$w)}]} {set case 0}
  set TH(Search,Case,$w) 1
  set i [th_Text_string_first $w "<a " "$index +1c"]
  set TH(Search,Case,$w) $case
  return $i
}

# Returns the beginning of the previous anchor, or the beginning of this one.
proc th_anchor_prev {w index} {
  if {[$w compare [set begin [th_anchor_begin $w $index]] != $index]} {
    return $begin 
  } else {return [th_anchor_begin $w "$index -1c"]
}}

proc th_html_mark {w} {
  th_Text_insert $w "\n"
  if {[lsearch {</A> </a>} [$w get "insert -5c" "insert -1c"]] >= 0} {
    th_Text_balance_add_tag_range $w anchor th_anchor_begin [list "<" ">"]
  }
  if {[$w get "insert-2c"] != "\n"} {
    if {[set begin [th_para_begin $w "insert-1l"]] == ""} {return}
    set end "insert-1c"
    $w tag remove paragraph "$begin -1c" "$end +1c"
    $w tag add paragraph $begin $end
}}


