#
# Module for browsing around in Entry widgets
#

# where is an index of characters, starting from 0. Puts cursor at $where,
# and makes cursor visible. If dont_stay is 1, and insert is already at the
# right place, beep.
proc th_Entry_goto {w where {dont_stay 1}} {
  if {$dont_stay && ([$w index $where] == [$w index insert])} {th_beep ; return 0}
  $w icursor $where
  set v [lindex [$w configure -width] 4]
  if {[lindex [$w configure -state] 4] == "disabled"} {
    $w view [$w index insert]
  } elseif {![th_Entry_visible_cursor $w $v]} {
      $w view [expr [$w index insert] - ($v / 2)]}
  return 1
}

# where is an index, as in above. Puts view at $where, and makes cursor
# visible.
proc th_Entry_scroll {w where {v ""}} {
  if {[$w index @0] == [$w index $where]} {th_beep ; return 0}
  $w view $where
  if {($v == "")} {set v [lindex [$w configure -width] 4]}
  if {![th_Entry_visible_cursor $w $v]} {
    $w icursor [expr [$w index @0] + ($v / 2)]
  }
  return 1
}

# Returns 1 if cursor is currently visible.
proc th_Entry_visible_cursor {w {v ""}} {
  if {($v == "")} {set v [lindex [$w configure -width] 4]}
  if {([$w index insert] <= [$w index @0]) ||
      ([$w index insert] >= [expr [$w index @0] + $v])} {
    return 0} else {return 1
}}


# Selects from cursor to end.
proc th_Entry_select_next_line {w} {
  if {[catch "$w index sel.last"]} { set start insert
  } elseif {([$w index sel.first] > [$w index insert]) ||
      ([$w index sel.last] < [$w index insert])} {
    $w select clear
    set start insert
  } else {set start sel.first}
  $w select from $start
  $w select to end
}

proc th_Entry_select_range {w start end} { 
  set s [$w index $start]
  set e [$w index $end]
  if {$s > $e} {th_beep ; return}
  $w select from $s
  $w select to $e
}

# Selects from mark to cursor.
proc th_Entry_select_region {w} {
  global TH
  if {[catch "set TH(Mark,$w)"]} {th_beep ; return}
  if {[$w index insert] > $TH(Mark,$w)} {
    th_Entry_select_range $w $TH(Mark,$w) [expr [$w index insert] -1]
  } else {th_Entry_select_range $w insert [expr $TH(Mark,$w) -1]
}}

# Exchanges cursor with mark.
proc th_Entry_exchange_mark {w} {
  global TH
  if {[catch "set TH(Mark,$w)"]} {th_beep ; return}
  set i [$w index insert]
  th_Entry_goto $w $TH(Mark,$w)
  set TH(Mark,$w) $i
}


