#
# Code to generate the frame used to hold entries, messages, etc.
#

source "[file dirname [info script]]/../aux/teach_bind.tcl"

# Help text.
set TH_Frame_Help $TH_Teach_Bind_Help ; append TH_Frame_Help {

Bugs / Limitations

The frame for entries and messages doesn't become visible until it is needed.
This program tries to pack it right underneath the widget it applies to. You can
move it somewhere else using packeth. One frame gets created for every toplevel
window; if a widget has commands that require a frame (such as Goto Index), and
a frame doesn't exist for that widget (such as if class bindings were applied to
that widget's class), the last frame created in the widget's window will be
used. So if you choose to teach all Text widgets, the Text widget you click on
will get the frame underneath it, and all Text widgets will use that frame,
unless you manually give each of them their own.
}

proc teach_binding_code {app binding} {
  global All_Bindings
  if {[catch "send \{$app\} set TH(Binding,$binding)"]} {
    do_cmd $app "set TH(Binding,$binding) \{[lindex $All_Bindings($binding) 0]\}\n" 0
}}

# Gives app all the code necessary to create a frame.
proc teach_frame_code {app widget} {
  include_files $app {common.tcl th_beep} {frame.tcl th_show_entry}
  set f [send $app winfo toplevel $widget] ; append f ".th_frame"
  if {$f == "..th_frame"} {set f .th_frame}
  if {![send $app winfo exists $f]} {
    do_cmd $app "frame $f\nset TH(Frame) $f\npack $f -fill x [pack_side_parms $widget bottom "send \{$app\}"]\n" 0
  }
  foreach binding {OK Cancel} {teach_binding_code $app $binding}
  return $f
}

# For a widget, returns the appropriate bindings. (Calls widget_frame_bindings
# and adds keys to manipulate the entries.)
proc widget_frame_bindings {bindings} {
  return [lappend bindings [list Cancel th_beep]]
}
