#
# Bindings for Tclth
#


set Bindings(Tcl) {
  {Begin_Proc 		{th_Text_goto %W [th_proc_begin %W insert]}}
  {End_Proc		{th_Text_goto %W [th_proc_end %W insert]}}
  {Next_Proc		{th_Text_goto %W [th_proc_next %W insert]}}
  {Prev_Proc		{th_Text_goto %W [th_proc_prev %W insert]}}
  {Select_Proc		{th_proc_select %W}}
  {Kill_Proc		{th_Text_kill_range %W [th_proc_begin %W insert] [th_proc_end %W insert]}}
  {Split_Tcl		{th_tcl_mark %W}}
  {Reformat_tclcomment	{th_tclcomment_format %W [th_tclcomment_begin %W insert] [th_tclcomment_end %W insert]}}
  {Update_Proc 		{th_Text_tag_regions %W function th_proc_begin th_proc_end th_proc_next}}
  {Update_tclcomment	{th_Text_tag_regions %W comment th_tclcomment_begin th_tclcomment_end th_tclcomment_next}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Begin_Proc End_Proc Next_Proc Prev_Proc Select_Proc
	Kill_Proc Reformat_tclcomment Update_Proc Update_tclcomment Split_Tcl}


set TH_Bindings_Help {
Tcl Functions

This module introduces the concept of procedures and comments in the Tcl coding
style to text widgets. It adds some simple editing and browsing commands for
procedures and comments. One can traverse between procedures with Control-N and
Control-P. Control-N puts the cursor at the beginning of the next procedure, and
Control-P puts the cursor at the beginning of the previous procedure (or current
one if it is not already there). One can select the current procedure with
Control-J. And Control-A moves to the beginning of the current procedure, while
Control-E goes to the end.

				Control-
				   P
Procedure:	Traversal:	 A + E
				   N
		Select:		   J

There is one editing feature for procedures and one for comments. Control-U
kills the current procedure, it can be yanked, though not undone. Meta-j can be
used to reformat the comment containing the cursor, so that every line in the
comment is as long as the widget's width, but not longer.

				Control-
Procedure:	Delete:		 H + D
Comment:	Adjust:		Meta-j

Tclth also works with taggeth to provide an index of procedures and comments. If
taggeth is included, it adds two menu options called "Update Comments" and
"Update Procedures" to the Index menu. These options add 'procedure' and
'comment' tags to each procedure and comment, respectively. This does not
visibly alter the text, but one can then go to any procedure or comment quickly
using the Tags submenu off the Index menu. Some editing commands will
automatically add the tags for you, so you can do some editing without
explicitly calling these features.
}


