#
# Bindings for Lispth
#


set Bindings(Lisp) {
  {Begin_Defun 		{th_Text_goto %W [th_defun_begin %W insert]}}
  {End_Defun		{th_Text_goto %W [th_defun_end %W insert]}}
  {Next_Defun		{th_Text_goto %W [th_defun_next %W insert]}}
  {Prev_Defun		{th_Text_goto %W [th_defun_prev %W insert]}}
  {Select_Defun		{th_defun_select %W}}
  {Kill_Defun		{th_Text_kill_range %W [th_defun_begin %W insert] [th_defun_end %W insert]}}
  {Split_Lisp		{th_lisp_mark %W}}
  {Reformat_lispcomment	{th_lispcomment_format %W [th_lispcomment_begin %W insert] [th_lispcomment_end %W insert]}}
  {Update_Defun 		{th_Text_tag_regions %W defun th_defun_begin th_defun_end th_defun_next}}
  {Update_lispcomment	{th_Text_tag_regions %W comment th_lispcomment_begin th_lispcomment_end th_lispcomment_next}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Begin_Defun End_Defun Next_Defun Prev_Defun Select_Defun
	Kill_Defun Reformat_lispcomment Update_Defun Update_lispcomment
	Split_Lisp}


set TH_Bindings_Help {
Lisp Functions

This module introduces the concept of functions and comments in the Lisp coding
style to text widgets. It adds some simple editing and browsing commands for
functions and comments. One can traverse between functions with Control-N and
Control-P. Control-N puts the cursor at the beginning of the next function, and
Control-P puts the cursor at the beginning of the previous function (or current
one if it is not already there). One can select the current function with
Control-J. And Control-A moves to the beginning of the current function, while
Control-E goes to the end.

				Control-
				   P
Defunedure:	Traversal:	 A + E
				   N
		Select:		   J

There is one editing feature for functions and one for comments. Control-U kills
the current function, it can be yanked, though not undone. Meta-j can be used to
reformat the comment containing the cursor, so that every line in the comment is
as long as the widget's width, but not longer.

				Control-
Defunedure:	Delete:		 H + D
Comment:	Adjust:		Meta-j

Lispth also works with taggeth to provide an index of functions and comments. If
taggeth is included, it adds two menu options called "Update Comments" and
"Update Defuns" to the Index menu. These options add 'function' and 'comment'
tags to each function and comment, respectively. This does not visibly alter the
text, but one can then go to any function or comment quickly using the Tags
submenu off the Index menu. Some editing commands will automatically add the
tags for you, so you can do some editing without explicitly calling these
features. 
}


