#
# Bindings for Focuth
#

set Bindings(Focus) {
  {Focus_Next 		{if {[catch {focus [th_next_widget %W]}]} {focus [th_next_widget . [winfo class %W]]}}}
  {Focus_Previous 	{if {[catch {focus [th_previous_widget %W]}]} {focus [th_previous_widget . [winfo class %W]]}}}
}

# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Focus_Next Focus_Previous}


set TH_Bindings_Help {
Focus Functions

There are two types of focus available, focus between a particular list of
widgets, and focus between all widgets of a particular class (such as Entry). If
a widget list is selected, then Control-n moves forward through the focus list,
and Control-p moves backward. If the focus is specified for all widgets of a
particular class, then Control-n moves to the next widget of the same class, and
Control-p moves to the previous widget of the same class. Only widgets that are
mapped (i.e. not iconified), and that are not disabled can be focused into, if a
widget is unmapped or disabled, that widget will be skipped. If no other widget
is available for a focus, then the focus is returned to the widget that
originally had the focus. The Next and Prior keys act the same as Control-n and
Control-p.

Focus:	Next:		Control-n	Next
	Previous:	Control-p	Prior
}
