#
# Bindings for Browseth
#

set Bindings(Browse,Text) {
  {Scroll_Line_Begin 	{th_Text_scroll %W {@0,0 -1 lines}}}
  {Scroll_Line_End	{th_Text_scroll %W {@0,0 +1 lines}}}
  {Scroll_Page_Begin 	{th_Text_scroll %W "@0,0 -[expr [lindex [%W configure -height] 4] -1] lines"}}
  {Scroll_Page_End 	{th_Text_scroll %W "@0,0 +[expr [lindex [%W configure -height] 4] -1] lines"}}
  {Goto_Char_Left  	{th_Text_goto %W {insert -1c}}}
  {Goto_Char_Right 	{th_Text_goto %W {insert +1c}}}
  {Goto_Char_Up 	{th_Text_adjacent_line %W -1}}
  {Goto_Char_Down	{th_Text_adjacent_line %W +1}}
  {Goto_Word_Left 	{th_Text_goto %W {insert -1c wordstart}}}
  {Goto_Word_Right	{th_Text_goto %W {insert wordend}}}
  {Goto_Screen_Left 	{th_Text_goto %W {insert linestart}}}
  {Goto_Screen_Right 	{th_Text_goto %W {insert lineend}}}
  {Goto_Screen_Up	{th_Text_goto %W @0,0}}
  {Goto_Screen_Down 	{th_Text_goto %W "@0,0 +[lindex [%W configure -height] 4] l -1c"}}
  {Goto_Edge_Begin 	{th_Text_goto %W 1.0 0}}
  {Goto_Edge_End 	{th_Text_goto %W end 0}}
  {Center_Cursor 	{th_Text_scroll %W "insert -[expr [lindex [%W configure -height] 4] / 2] l"}}
  {Center_Screen 	{th_Text_goto %W "@0,0 +[expr [lindex [%W configure -height] 4] / 2] l"}}
  {Select_Line 		{th_Text_select_next_line %W}}
  {Select_Region 	{th_Text_select_region %W}}
  {Select_All 		{%W tag add sel 1.0 end}}
  {Select_Clear 	{%W tag add sel 1.0 ; %W tag remove sel 1.0 end}}
  {Goto_Mark 		{th_Text_exchange_mark %W}}
  {Mark 		{%W mark set mark insert}}
  {Goto 		{th_goto %W}}
}
set Bindings(Browse,Entry) {
  {Scroll_Line_Begin 	{th_Entry_scroll %W [expr [%W index @0] -1]}}
  {Scroll_Line_End	{th_Entry_scroll %W [expr [%W index @0] +1]}}
  {Scroll_Page_Begin 	{th_Entry_scroll %W [expr [%W index @0] - [lindex [%W configure -width] 4] + 1]}}
  {Scroll_Page_End 	{th_Entry_scroll %W [expr [%W index @0] + [lindex [%W configure -width] 4] - 1]}}
  {Goto_Char_Left 	{th_Entry_goto %W [expr [%W index insert] - 1]}}
  {Goto_Char_Right 	{th_Entry_goto %W [expr [%W index insert] + 1]}}
  {Goto_Word_Left 	{th_Entry_goto %W [th_string_wordstart [%W get] [expr [%W index insert] -1]]}}
  {Goto_Word_Right 	{th_Entry_goto %W [th_string_wordend [%W get] [%W index insert]]}}
  {Goto_Screen_Left 	{th_Entry_goto %W @0}}
  {Goto_Screen_Right 	{th_Entry_goto %W [expr [%W index @0] + [lindex [%W configure -width] 4] - 1]}}
  {Goto_Edge_Begin 	{th_Entry_goto %W 0 0}}
  {Goto_Edge_End 	{th_Entry_goto %W end 0}}
  {Center_Cursor 	{th_Entry_scroll %W [expr [%W index insert] - [lindex [%W configure -width] 4] / 2]}}
  {Center_Screen 	{th_Entry_goto %W [expr [%W index @0] + ([lindex [%W configure -width] 4] / 2)]}}
  {Select_Line 		{th_Entry_select_next_line %W}}
  {Select_Region 	{th_Entry_select_region %W}}
  {Select_All 		{%W select from 0 ; %W select to end}}
  {Select_Clear 	{%W select from 0 ; %W select to end ; %W select clear}}
  {Goto_Mark 		{th_Entry_exchange_mark %W}}
  {Mark 		{set TH(Mark,%W) [%W index insert]}}
  {Goto 		{th_goto %W}}
}
set Bindings(Browse,Scrollbar) {
  {Mark 		{set TH(Mark,%W) [lindex [%W get] 2]}}
  {Goto_Mark 		{th_Scrollbar_exchange_mark %W}}
  {Goto 		{th_goto %W}}
}
set Bindings(Browse,Scrollbar,X) {
  {Goto_Char_Left 	{th_Scrollbar_goto %W [expr [lindex [%W get] 2] -1]}}
  {Goto_Char_Right	{th_Scrollbar_goto %W [expr [lindex [%W get] 2] +1]}}
  {Scroll_Page_Left 	{th_Scrollbar_goto %W [expr [lindex [%W get] 2] - [th_Scrollbar_size %W]]}}
  {Scroll_Page_Right 	{th_Scrollbar_goto %W [expr [lindex [%W get] 2] + [th_Scrollbar_size %W]]}}
  {Goto_Edge_Left 	{th_Scrollbar_goto %W 0}}
  {Goto_Edge_Right 	{th_Scrollbar_goto %W [lindex [%W get] 0]}}
}
set Bindings(Browse,Scrollbar,Y) {
  {Goto_Char_Up 	{th_Scrollbar_goto %W [expr [lindex [%W get] 2] -1]}}
  {Goto_Char_Down	{th_Scrollbar_goto %W [expr [lindex [%W get] 2] +1]}}
  {Scroll_Page_Begin 	{th_Scrollbar_goto %W [expr [lindex [%W get] 2] - [th_Scrollbar_size %W]]}}
  {Scroll_Page_End 	{th_Scrollbar_goto %W [expr [lindex [%W get] 2] + [th_Scrollbar_size %W]]}}
  {Goto_Edge_Begin 	{th_Scrollbar_goto %W 0}}
  {Goto_Edge_End 	{th_Scrollbar_goto %W [lindex [%W get] 0]}}
}
set Bindings(Browse,Scale) {
  {Mark 		{set TH(Mark,%W) [%W get]}}
  {Goto_Mark 		{th_Scale_exchange_mark %W}}
  {Goto 		{th_goto %W}}
}
set Bindings(Browse,Scale,X) {
  {Goto_Char_Left 	{th_Scale_goto %W [expr [%W get] - 1]}}
  {Goto_Char_Right	{th_Scale_goto %W [expr [%W get] + 1]}}
  {Goto_Edge_Left 	{th_Scale_goto %W [lindex [%W configure -from] 4]}}
  {Goto_Edge_Right 	{th_Scale_goto %W [lindex [%W configure -to] 4]}}
}
set Bindings(Browse,Scale,Y) {
  {Goto_Char_Up 	{th_Scale_goto %W [expr [%W get] - 1]}}
  {Goto_Char_Down	{th_Scale_goto %W [expr [%W get] + 1]}}
  {Goto_Edge_Begin 	{th_Scale_goto %W [lindex [%W configure -from] 4]}}
  {Goto_Edge_End 	{th_Scale_goto %W [lindex [%W configure -to] 4]}}
}
set Bindings(Browse,Listbox) {
  {Select_Line 		{th_Listbox_select_next_line %W}}
  {Select_Region 	{th_Listbox_select_region %W}}
  {Select_All 		{%W select from 0 ; %W select to end}}
  {Select_Clear 	{%W select from 0 ; %W select to end ; %W select clear}}
  {Goto_Mark 		{th_Listbox_exchange_mark %W}}
  {Mark 		{set TH(Mark,%W) [%W nearest 0]}}
  {Goto 		{th_goto %W}}
}
set Bindings(Browse,Canvas) {
  {Goto_Char_Left 	{catch {th_Canvas_goto %W [%W focus] [expr [%W index [%W focus] insert] - 1]}}}
  {Goto_Char_Right 	{catch {th_Canvas_goto %W [%W focus] [expr [%W index [%W focus] insert] + 1]}}}
  {Goto_Word_Left 	{catch {th_Canvas_goto %W [%W focus] [th_string_wordstart [lindex [%W itemconfigure [%W focus] -text] 4] [expr [%W index [%W focus] insert] -1]]}}}
  {Goto_Word_Right 	{catch {th_Canvas_goto %W [%W focus] [th_string_wordend [lindex [%W itemconfigure [%W focus] -text] 4] [%W index [%W focus] insert]]}}}
  {Goto_Screen_Left 	{th_Canvas_goto %W [%W focus] 0}}
  {Goto_Screen_Right 	{th_Canvas_goto %W [%W focus] end}}
  {Select_Line 		{th_Canvas_select_next_line %W [%W focus]}}
  {Select_Region 	{th_Canvas_select_region %W [%W focus]}}
  {Select_All 		{catch {%W select from [%W focus] 0 ; %W select to [%W focus] end}}}
  {Select_Clear 	{catch {%W select from [%W focus] 0 ; %W select to [%W focus] end ; %W select clear}}}
  {Goto_Mark 		{th_Canvas_exchange_mark %W [%W focus]}}
  {Mark 		{catch {set TH(Mark,%W,[%W focus]) [%W index [%W focus] insert]}}}
}
set Bindings(Browse,Misc,X) {
  {Scroll_Line_Left 	{th_Misc_line %W x -1}}
  {Scroll_Line_Right	{th_Misc_line %W x 1}}
  {Scroll_Page_Left 	{th_Misc_page_backward %W x}}
  {Scroll_Page_Right 	{th_Misc_page_forward %W x}}
  {Goto_Edge_Left 	{%W xview 0}}
  {Goto_Edge_Right 	{th_Misc_edge_end %W x}}
}
set Bindings(Browse,Misc,Y) {
  {Scroll_Line_Begin 	{th_Misc_line %W y -1}}
  {Scroll_Line_End	{th_Misc_line %W y 1}}
  {Scroll_Page_Begin 	{th_Misc_page_backward %W y}}
  {Scroll_Page_End 	{th_Misc_page_forward %W y}}
  {Goto_Edge_Begin 	{%W yview 0}}
  {Goto_Edge_End 	{th_Misc_edge_end %W y}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Scroll_Line_Begin Scroll_Line_End Scroll_Line_Left
  Scroll_Line_Right Scroll_Page_Begin Scroll_Page_End Scroll_Page_Left
  Scroll_Page_Right Goto_Char_Left Goto_Char_Right Goto_Char_Up Goto_Char_Down
  Goto_Word_Left Goto_Word_Right Goto_Screen_Left Goto_Screen_Right
  Goto_Screen_Up Goto_Screen_Down Goto_Edge_Begin Goto_Edge_End Goto_Edge_Left
  Goto_Edge_Right Center_Cursor Center_Screen Select_Line Select_Region
  Select_All Select_Clear Goto_Mark Mark Goto OK Cancel}


set TH_Bindings_Help {
Browsing Functions

These are bindings to control the location of a cursor in the widget, and to
control the scrolling view of the widget, if it can be scrolled, and to control
the selection, if the widget allows selection. We will deal with each of these
items in turn.

Scrolling is allowed on any widget that supports a scrollbar, or that could
support one. Currently, this includes text, entry, listbox, and canvas widgets.
Note that texts can't scroll horizontally (yet!) and entries can't scroll
vertically. The selection is unaffected. If the widget has a cursor, it is left
alone, unless it has scrolled off the edge of the viewable window, in which case
it is broght to the center of the view. One can scroll forward, backward, left,
and right, depending on the widget. If a widget only supports one type of
scrolling (text and entry widgets), then it supports forward and backward
scrolling. If it supports both types, forward and backward scroll the widget
down and up, respectively.

One can scroll a widget forward one line with Control-z and backward one line
with Meta-z. Control-Z scrolls a widget one character to the right and Meta-Z
scrolls a widget one character to the left. The arrow keys can scroll a widget
that does not have a cursor.

                    Meta-z              Up
 Scroll: Line: Meta-Z + Control-Z   Left + Right         
                   Control-z           Down 

Scrolling one page is also possible. One can scroll a widget forward one 'page'
with Control-v, and backward one page with Meta-v. Likewise, Control-V scrolls
to the right one page and Meta-V scrolls to the left one page. Scrollbars also
have the ability to do page scrolling, in whichever dimension they reside. A
scrollbar's paging function has the same effect as paging the widget they scroll
over. Using the arrow keys with Shift pages the window in the arrow's direction.

Finally, one can adjust the view of a Text or Entry widget so that the cursor is
in the center of the view, using Control-l. This does not move the cursor, just
the view:
                                      Shift-
                   Meta-v              Up
Scroll: Page: Meta-V + Control-V   Left + Right
                  Control-v           Down
Center cursor	Control-l

Gotoing is similar to scrolling, except that instead of changing the view, and
perhaps dragging the cursor along afterwards, one moves the cursor, and changes
the view to keep the cursor visible. While cursors are only available to active
text and entry widgets, many other widgets have a 'value' which can act like a
cursor. For example, scales have a numerical value which can be adjusted like a
cursor. Inactive text and entry widgets still have cursors, though they are
invisible, so they are considered to be on the top line for texts, and the left
edge for entries. Likewise listbox and canvas widgets consider their upper left
corner as a sort of cursor for gotoing purposes. Unlike scrolling, gotoing
involves left, right, up, and down, as the widget permits.

One can goto one unit left using Control-b, right using Control-f, up using
Control-p, and down using Control-n. This unit is usually a character or line of
text, but it can instead be a scrollbar or scale's increment value. The arrow
keys have the same functions as gotoing.

Entries and text widgets also have the ability to go forward or backward by one
word. Meta-b moves backward one word, and Meta-f moves forward one word.

                 Control-p             Up
Goto: Char: Control-b + Control-f  Left + Right
                 Control-n            Down
Goto: Word: Meta-b + Meta-f

Text and Entries also have a 'screen' option that puts the cursor at the edge of
the currently viewable window. Pressing Control-a puts the cursor at the left
edge of the screen and Control-e puts the cursor at the right edge of the screen
(on the current line). And pressing Meta-, puts the cursor at the first viewable
character in the text widget, while pressing Meta-. puts the cursor at the last
viewable character in the text widget.

                      Meta-,
Goto: Screen: Control-a + Control-e
                      Meta-.

One can move the cursor to the edge of the widget as well. For widgets without a
cursor, this simply means scrolling to the edge of the widget. Like scrolling,
if a widget supports one dimension, it is Beginning and End, if it supports two,
Left and Right are also added, and Beginning and End mean top and bottom
respectively. One moves to the beginning of the widget using Meta-< and the end
with Meta->, to the left with Control-< and to the right with Control->.
Pressing Control with an arrow key has the same effect.

                                    Control-
                    Meta-<             Up
Goto: Edge: Control-< + Control->  Left + Right
                    Meta->            Down

There are a handful of special goto commands available to some widgets. First of
all, one can move the cursor to the center of the screen with Control-L. One can
set a 'mark' using Control-' ' (that's a space right there), and then goto that
mark using Control-x. After Control-x goes to the mark, it moves the mark to the
old cursor location, so you can use Control-x to switch between two locations.

Mark:	Set:	Control-space
Goto:	Center:	Control-L
	Mark:	Control-x

Finally, one can enter an index to goto using Meta-g. This brings up an entry,
into which you type an index to go to, and the cursor is placed at that index.
In the entry, you can press Return to go to the index currently entered, or
Control-g to forget about going to an index. The syntax of the index varies with
the widget, see the manpages on the widgets for details, but here's a quick
overview:

The index of Scale widgets is the scale value. For scrollbar widgets, it is the
numeric values provided by the scrollbar (which is not particularly helpful, oh
well, you can't have everything). For listbox widgets, 0 is the topmost item, 1
the next, etc. and end is the last item. For entries, 0 is the leftmost
character, 1 the next, etc. and end is the last item. For texts, 1.0 is the
first character on the first line, 1.1 is the 2nd character on the first line,
2.5 is the 6th character on the 2nd line, end is the last character. For text
widgets, you can just enter 1 for the first line, 2 for the second, or you can
enter a valid text index.

Goto:	Specify:	Meta-g
	Execute:	Return (or Control-m)
	Abort:		Control-g

There are four options offered for selection. One can use Control-K (or
control-k) to select a line of text. Pressing Control-K multiple times selects
more lines after the cursor. This can be used in the same fashion for listboxes
and entries, though entries it selects to the end of the line. One can also
select a region by setting the mark somewhere (with Control-space) and putting
the cursor at the other end of the region and press Control-W (or Control-w).
One can also select all the text with Meta-w. Finally one can clear the
selection with Control-c. The Select key in association with various other keys
can do the same functions.

Select	Line 	Control-K (Control-k) Select
	Region	Control-W (Control-w) Control-Select
	All	Meta-W                Meta-Select
	Clear	Control-c             Shift-Select
}

