/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *    Please See COPYRIGHT notice.                                  *
 *                                                                  *
/*  Terminal descriptor for DOS running PC/NFS telnet or Excelan telnet */
/********************************************************************/

# include	"tty.h"

void
main()
{

	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		213,		/* Top left of window.			   */
		184,		/* Top right of window.			   */
		212,		/* Bottom left of window.		   */
		190,		/* Bottom right of window.		   */
		179,		/* Vertical bar for window sides.	   */
		205,		/* Top and bottom horizontal bar for window.*/
		0xd1,		/* Top join.				    */
		0xcf,		/* Bottom join.				    */
		0xd8,		/* Window 4-way intersection.		    */
		0xb5,		/* Left hand join.			    */
		0xc6		/* Right hand join.			    */
		);

	/***********************************************/
	/*   Define   escape   sequences   used   for  */
	/*   special optimisations on output.	       */
	/***********************************************/
	set_term_features(
		NULL,			/* Sequence to clear 'n' spaces.    */
		"%c",			/* Sequence to print characters     */
					/* with top bit set.		    */
		"\x1B[23m",		/* Insert-mode cursor.		    */
		"\x1B[24m",		/* Overwrite-mode cursor.	    */
		"\x1B[28;10;13m",	/* Insert-mode cursor (on virtual space).    */
		"\x1B[28;1;8m",		/* Overwrite-mode cursor (on virtual space). */
		"\x1B\x1B",		/* Print ESCAPE character graphically.	     */
		"\x[%b",		/* Escape sequence to repeat last character. */
		TRUE,			/* ESC [0m resets color.	    */
		TRUE,			/* Terminal supports color.	    */
		"\x1B[%dC"		/* Move cursor %d columns	    */
					/* (Not available in termcap).	    */
		);
}
