/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          acorn.m                                            */
/*  Author:        P. D. Fox                                          */
/*  Created:       17 May 1991                     		      */
/*                                                                    */
/*  Description:  Terminal description for xterm running on an Acorn  */
/*                Archimedes under Unix.                              */
/**********************************************************************/

/*static char sccs_id[] = "%Z% %M% %R%.%L%";*/

# include	"tty.h"

void
main()
{
	/***********************************************/
	/*   Set   characters   used   for   extended  */
	/*   graphics support when drawing windows.    */
	/***********************************************/
	set_term_characters(
		"l",	/* Top left of window.			    */
		"k",	/* Top right of window.			    */
		"m",	/* Bottom left of window.		    */
		"j",	/* Bottom right of window.		    */
		"x",	/* Vertical bar for window sides.	    */
		"q",	/* Top and bottom horizontal bar for window.*/
		"w",	/* Top join.				    */
		"v",	/* Bottom join.				    */
		"n",	/* Window 4-way intersection.		    */
		"u",	/* Left hand join.      		    */
		"t"	/* Right hand join.      		    */
		);
	/***********************************************/
	/*   Define   escape   sequences   used   for  */
	/*   special optimisations on output.	       */
	/***********************************************/
	set_term_features(
		NULL,		/* Sequence to clear 'n' spaces.	  */
		NULL,		/* Sequence to print characters with top  */
		     		/* bit set.				  */
		NULL,		/* Insert-mode cursor.			  */
		NULL,		/* Overwrite-mode cursor.		  */
		NULL,		/* Insert-mode cursor (on virtual space). */
		NULL,		/* Overwrite-mode cursor (on virtual space).*/
		NULL,		/* Print ESCAPE character graphically.	    */
		NULL,		/* Escape sequence to repeat last character.*/
		FALSE,		/* ESC [0m resets color.		    */
		FALSE,		/* Terminal supports color.		    */
		"\x1B[%dC",	/* Sequence to move cursor on same line   */
		TRUE,   	/* ESC[K gives us a black erased line.		*/
		FALSE,		/* Allow scrolling (ins/del)		  */
		"\x1B(0",	/* Enter graphics mode.			  */
		"\x1B(B"	/* Exit graphics mode.			  */
		);


	/***********************************************/
	/*   Define sequences generated by keyboard.   */
	/***********************************************/
	set_term_keyboard(
		/***********************************************/
		/*   These  are  the  TOP  Function keys on a  */
		/*   Sun   4   keyboard.   These  definitions  */
		/*   require    remapping    of   the   xterm  */
		/*   Function  keys  as  they  don't  use the  */
		/*   standard escape sequences.		       */
		/***********************************************/
		F1_F12, quote_list(
			"\x1B[224z", "\x1B[225z", "\x1B[226z", "\x1B[227z", 
			"\x1B[228z", "\x1B[229z", "\x1B[230z", "\x1B[231z",
			"\x1B[232z", "\x1B[233z", "\x1B[234z", "\x1B[235z"),

		/***********************************************/
		/*   Shift F1 to Shift F12.		       */
		/***********************************************/
		SHIFT_F1_F12, quote_list(
			"\x1B[SF1~", "\x1B[SF2~", "\x1B[SF3~", "\x1B[SF4~", 
			"\x1B[SF5~", "\x1B[SF6~", "\x1B[SF7~", "\x1B[SF8~",
			"\x1B[SF9~", "\x1B[SF10~", "\x1B[SF11~", "\x1B[SF12~"),

		/***********************************************/
		/*   CTRL F1 TO CTRL F12.		       */
		/***********************************************/
		CTRL_F1_F12, quote_list(
			"\x1B[CF1~", "\x1B[CF2~", "\x1B[CF3~", "\x1B[CF4~", 
			"\x1B[CF5~", "\x1B[CF6~", "\x1B[CF7~", "\x1B[CF8~",
			"\x1B[CF9~", "\x1B[CF10~", "\x1B[CF11~", "\x1B[CF12~"),


		/***********************************************/
		/*   Alt F1 to Alt F12.			       */
		/***********************************************/
		ALT_F1_F12, quote_list(
			"\x1B[mF1~", "\x1B[mF2~", "\x1B[mF3~", "\x1B[mF4~", 
			"\x1B[mF5~", "\x1B[mF6~", "\x1B[mF7~", "\x1B[mF8~",
			"\x1B[mF9~", "\x1B[mF10~", "\x1B[mF11~", "\x1B[mF12~"),

		/***********************************************/
		/*   These are the ALT-letter keys.	       */
		/***********************************************/
		ALT_A_Z, quote_list(
			"\xe6", "\xe2", "\xa2", "\xf0", "\xe5", /* a-e */
			"\x81", "\xe7", "\xe8", "\xe9", "\xea", /* f-j */
			"\xeb", "\xec", "\xb5", "\xee", "\xf8",
			"\xfe", "\xf1", "\xb6", "\xdf", "\xf4",
			"\xF5", "\xf6", "\xf7", "\xbb", "\x80",
			"\xab"),
	
		/***********************************************/
		/*   These   are   the   LEFT-letter  Numeric  */
		/*   keys.  Not  all  of these are accessible  */
		/*   from openwin.			       */
		/***********************************************/
		ALT_0_9, quote_list(
			"\x1B0", "\x1B1", "\x1B2", "\x1B3", "\x1B4",
			"\x1B5", "\x1B6", "\x1B7", "\x1B8", "\x1B9"),
		
		/***********************************************/
		/*   Keypad 0 to Keypad 9.		       */
		/***********************************************/
		KEYPAD_0_9, quote_list(
                        "\x1BOp", "\x1BOq", "\x1BOr", "\x1BOs",
                        "\x1BOt", "\x1BOu", "\x1BOv", "\x1BOw",
                        "\x1BOx", "\x1BOy"),
		KEYPAD_2, "OB",
		KEYPAD_4, "OD",
		KEYPAD_6, "OC",
		KEYPAD_8, "OA",
		
		COPY,		"\x1BOk",
		CUT,		"\x1BOm",
		BACK_TAB, 	"\x1B\t",
		KEY_INS,	"[2z",
		KEY_COPY,	"[4z",
		KEY_PAGEUP,	"[5z",
		KEY_PAGEDOWN,	"[6z",
		MOUSE_KEY, "[M"
	);
	assign_to_key("<Mouse>", "xterm_mouse");
	
}
/**********************************************************************/
/*   Macro  called  when  a  mouse  button is hit from an Xterm when  */
/*   the mouse option is enabled in the window.			      */
/**********************************************************************/
int	mouse_cnt = 0;
void
xterm_mouse()
{	int	ch1, ch2, ch3;

	ch1 = read_char(0);
	ch2 = read_char(0);
	ch3 = read_char(0);
	message("Mouse hit %d! %s%s%s (%d,%d)", 
		mouse_cnt++,
		ch1 == ' ' ? "o" : "-",
		ch1 == '!' ? "o" : "-",
		ch1 == '"' ? "o" : "-",
		ch2 - ' ', ch3 - ' '
		);
	/***********************************************/
	/*   Let  CRISP  do  the real work of working  */
	/*   out whats happened to the mouse keys.     */
	/***********************************************/
	process_mouse(ch1 == ' ', ch1 == '!', ch1 == '"', 
		ch2 - ' ' - 1, 
		ch3 - ' ' - 1);
}

