/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          scroll.cr                                          */
/*  Author:        P. D. Fox                                          */
/*  Created:       25 Jun 1991                     		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Code to implement scroll locking.                   */
/*                                                                    */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */
# include	"crisp.h"

int	sl_enabled = FALSE;
int	sl_line, sl_col;
int	sl_line2, sl_col2;
int	sl_win1, sl_win2;
int	sl_tline, sl_tcol;

/**********************************************************************/
/*   Function  called  when  ScrollLock  key pressed. It toggles the  */
/*   state of the scroll lock.					      */
/**********************************************************************/
void
scroll()
{	int	buf;

	if (!sl_enabled) {
		int	csrline, csrcol;

		sl_win1 = inq_window();
		inq_top_left(sl_tline, sl_tcol, NULL, csrline, csrcol);

		sl_line = csrline - sl_tline;
		sl_col  = csrcol - sl_tcol;
		buf = inq_buffer();
		/***********************************************/
		/*   If  we  have  another  window  on  view,  */
		/*   then  use  that  as  our  scroll  linked  */
		/*   window.				       */
		/***********************************************/
		if (next_window() >= 0 && inq_window() != sl_win1) {
			set_window(sl_win1);
			sl_win2 = get_window("Point to other window");
			set_window(sl_win1);
			set_buffer(buf);
			if (sl_win2 < 0)
				return;
			inq_top_left(sl_line2, sl_col2, sl_win2);
			}
		else
			sl_win2 = -1;
		message("Scroll Lock enabled.");
		register_macro(REG_KEYBOARD, "scroll_lock");
		}
	else {
		message("Scroll Lock disabled.");
		unregister_macro(REG_KEYBOARD, "scroll_lock");
		}
	sl_enabled = !sl_enabled;
}
/**********************************************************************/
/*   registered  macro  called whenever crisp is ready to read a key  */
/*   from  the  keyboard.  We  cause the other window and the scroll  */
/*   locked window to stay where we want them.			      */
/**********************************************************************/
int
scroll_lock()
{	int	line, col, csrline, csrcol;

	if (sl_win1 == inq_window()) {
		inq_top_left(line, col, NULL, csrline, csrcol);
		line = csrline - sl_line;
		col = csrcol - sl_col;
		set_top_left(line, col);
		if (sl_win2 >= 0) {
			set_top_left(
				sl_line2 + line - sl_tline, 
				sl_col2 + col - sl_tcol, 
				sl_win2,
				sl_line2 + line - sl_tline, 
				sl_col2 + col - sl_tcol);
			}
		refresh();
		}
	return 0;
}

/**********************************************************************/
/*   Function to get a window pointed to by user.		      */
/**********************************************************************/
int
get_window(string msg)
{	int	curwin = inq_window();
	int	win;
	
	/***********************************************/
	/*   Get user to change window first.	       */
	/***********************************************/
	if (change_window(NULL, msg) == 0)
		return -1;
	/***********************************************/
	/*   Figure  out  which  window  we're in and  */
	/*   then put us back where we came from.      */
	/***********************************************/
	win = inq_window();
	set_window(curwin);
	return win;
}
