/**************************************************************
 *
 *	CRISP - Custom Reduced Instruction Set Programmers Editor
 *
 *	(C) Paul Fox, 1989
 *
 *    Please See COPYRIGHT notice.
 *
 *   Code to allow us to implement getenv() and putenv() in
 *   a way that is portable to VMS which doesnt have putenv()
 *   on our system.
 *
 **************************************************************/
# include	"list.h"

# if !defined(VMS) || defined(MSDOS)
char	*
ggetenv(name)
char *name;
{	char *getenv();
	return getenv(name);
}
int
gputenv(name)
char *name;
{
	char *strdup();
	int	putenv();
	return putenv(strdup(name));
}
# else
static	Head_p	hd_env = NULL;

static List_p	glookup();

char	*
ggetenv(name)
char	*name;
{	List_p lp = glookup(name);
	char *cp;

	if (lp == NULL)
		return getenv(name);
	for (cp = (char *) ll_elem(lp); *cp != '=' && *cp; )
		cp++;
	return *cp == '=' ? cp + 1 : cp;
}
int
gputenv(name)
char	*name;
{	char *cp = strdup(name);
	List_p	lp;
	
	if ((lp = glookup(name)) != NULL) {
		chk_free((char *) ll_elem(lp));
		ll_delete(lp);
		}
	ll_append(hd_env, cp);
	return 0;
}
static List_p
glookup(name)
char *name;
{	int	len;
	List_p	lp;
	
	if (hd_env == NULL) {
		hd_env = ll_init();
		return NULL;
		}
		
	for (len = 0; name[len] != '=' && name[len]; )
		len++;
		
	for (lp = ll_first(hd_env); lp; lp = ll_next(lp)) {
		char *lname = (char *) ll_elem(lp);
		if (strncmp(name, lname, len) == 0 &&
		    lname[len] == '=')
			return lp;
		}
	return NULL;
}
# endif
