/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          debug.c                                            */
/*  Author:        P. D. Fox                                          */
/*  Created:       12 Jun 1990                     		      */
/*                                                                    */
/*  Copyright (c) 1990 Paul Fox                                       */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Support routines called from debugger.              */
/*                                                                    */
/**********************************************************************/

/*static char sccs_id[] = "%Z% %M% %R%.%L%";*/

# include	"crunch.h"
	
struct map {
	char	*name;
	int	val;
	};

struct map enum_tbl[] = {
	"TY_VOID",	TY_VOID,
	"TY_CHAR",	TY_CHAR,
	"TY_SHORT",	TY_SHORT,
	"TY_INT",	TY_INT,
	"TY_LONG",	TY_LONG,
	"TY_FLOAT",	TY_FLOAT,
	"TY_DOUBLE",	TY_DOUBLE,
	"TY_SIGNED",	TY_SIGNED,
	"TY_UNSIGNED",	TY_UNSIGNED,
	"TY_STRUCT",	TY_STRUCT,
	"TY_UNION",	TY_UNION,
	"TY_ENUM",	TY_ENUM,
	"TY_STRING",	TY_STRING,
	"TY_DECLARE",	TY_DECLARE,
	"TY_LIST",	TY_LIST,
	"TY_STRUCTI",	TY_STRUCTI,
	"TY_UNIONI",	TY_UNIONI,
	"SC_AUTO",	SC_AUTO,
	"SC_REGISTER",	SC_REGISTER,
	"SC_STATIC",	SC_STATIC,
	"SC_EXTERN",	SC_EXTERN,
	"SC_TYPEDEF",	SC_TYPEDEF,
	"TQ_CONST",	TQ_CONST,
	"TQ_VOLATILE",	TQ_VOLATILE,
	"TO_NOOP",	TO_NOOP,
	"TO_INIT",	TO_INIT,
	"TO_PTR",	TO_PTR,
	"TO_LIST",	TO_LIST,
	"TO_SYMBOL",	TO_SYMBOL,
	"TO_ARRAY",	TO_ARRAY,
	"TO_FUNC",	TO_FUNC,
	"K_NOOP",	K_NOOP,
	"K_IF",		K_IF,
	NULL, NULL
	};

static char *map_word PROTO((struct map *, int));
int	nt1 PROTO((node_t *, int));
int	ntp PROTO((node_t *, int));
int	nt PROTO((node_t *, int));


extern int struct_flag;
static char *
map_word(tbl, val)
struct map	*tbl;
int	val;
{	static char	buf[32];
	struct map *mp;
	
	for (mp = tbl; mp->name; mp++) {
		if (mp->val == val)
			return mp->name;
		}
	sprintf(buf, "<%x>", val);
	return buf;
}
# define	PRE_ORDER	1
# define	MID_ORDER	0
# define	POST_ORDER	0

int
nt(np, size)
node_t	*np;
int	size;
{
	return nt1(np, size);
}
int
nt1(np, size)
node_t	*np;
int	size;
{
	extern int flush_flag;
		
	size = ntp(np, size);
	if (np->left)
		size = nt(np->left, size);
	if (np->right)
		size = nt(np->right, size);
	if (flush_flag)
		fflush(stdout);
	return size;
}
int
ntp(np, size)
node_t *np;
int	size;
{
	if (np == NULL)
		return size;

	if (np->type == node_symbol) {
		if (!struct_flag)
			printf("'%s' ", np->atom.sval);
		return size;
		}
		
	if (np->type == node_integer) {
/*		printf("%ld ", np->atom.ival);*/
		return size;
		}
	
	if (np->atom.eval == TO_ARRAY) {
		if (np->right == NULL) {
			if (!struct_flag)
				printf("[] ");
			}
		else if (np->right->type == node_integer) {
			if (!struct_flag) {
				printf("[%ld] ", np->right->atom.ival);
				fflush(stdout);
				}
			return size * np->right->atom.ival;
			}
		return size;
		}

	if (np->atom.eval == TO_PTR) {
		if (!struct_flag)
			printf("*");
		return 4;
		}

	if (np->atom.eval == TO_FUNC) {
		if (!struct_flag)
			printf("() ");
		return size;
		}
	if (!struct_flag)
		printf("%s ", map_word(enum_tbl, np->atom.eval));
	return size;
}
