/*-------------------------------------------------------------------------
 *

 *   FILE
 *	PGenv.cc
 *
 *   DESCRIPTION
 *      PGenv is the environment for setting up a connection to a 
 *   postgres backend,  captures the host, port, tty, and options
 *
 *   NOTES
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/libpq++/pgenv.cc,v 1.1 1995/01/10 00:41:10 jolly Exp
 *
 *-------------------------------------------------------------------------
 */

#include <stdlib.h>
#include "libpq++.H"

static char* DefaultHost = "localhost";
static char* DefaultTTY = "/dev/null";
static char* DefaultOption = "";
static int DefaultPort = 4321;

// default ctor
// check the environment variables, PGHOST, PGPORT, and PGTTY
PGenv::PGenv()
{
  char* temp;
  int port;


  pqhost = NULL;
  pqtty = NULL;

  if (!(temp = getenv(ENV_DEFAULT_PORT)))
    port = DefaultPort;
  else
    port = atoi(temp);
  
  setValues(getenv(ENV_DEFAULT_HOST), port, getenv(ENV_DEFAULT_TTY));
}

PGenv::PGenv(char* host, int port, char* tty)
{
  pqhost = NULL;
  pqtty = NULL;

  setValues(host, port, tty);
}

PGenv::setValues(char* host, int port, char* tty)
{
  char* temp;

  temp = (host) ? host : DefaultHost;

  if (pqhost)
    free(pqhost);
  pqhost = dupstr(temp);

  pqport = port;

  temp = (tty) ? tty : DefaultTTY;
  if (pqtty)
    free(pqtty);

  pqtty = dupstr(temp);
}

PGenv::~PGenv()
{
  if (pqhost)
    free(pqhost);
  if (pqtty)
    free(pqtty);
}

