/*-------------------------------------------------------------------------
 *
 * pgtcl.c--
 *    
 *    libpgtcl is a tcl package for front-ends to interface with pglite
 *   It's the tcl equivalent of the old libpq C interface.
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/libpgtcl/pgtcl.c,v 1.1 1995/02/05 04:45:07 jolly Exp
 *
 *-------------------------------------------------------------------------
 */

#include "tcl.h"
#include "libpgtcl.h"
#include "pgtclCmds.h"

/*
 * PG_Init 
 *    initialization package for the PGLITE Tcl package
 *
 */

int
Pg_Init (Tcl_Interp *interp)
{
  /* register all pgtcl commands */

  Tcl_CreateCommand(interp,
		    "pg_connect",
		    Pg_connect,
		    (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);

  Tcl_CreateCommand(interp,
		    "pg_disconnect",
		    Pg_disconnect,
		    (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
  
  Tcl_CreateCommand(interp,
		    "pg_exec",
		    Pg_exec,
		    (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
  
  Tcl_CreateCommand(interp,
		    "pg_result",
		    Pg_result,
		    (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
  
  return TCL_OK;
}


