/*-------------------------------------------------------------------------
 *
 *   FILE
 *	pgmisc.cc
 *
 *   DESCRIPTION
 *       miscellaneous useful functions
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    /usr/local/devel/pglite/cvs/src/libpgtcl/pgmisc.c,v 1.1 1995/02/05 04:45:07 jolly Exp
 *
 *-------------------------------------------------------------------------
 */

#include <stdlib.h>
#include <stdio.h>

int
pqGets(char* s, int len, FILE* f)
{
  int c;

  if (f == NULL)
    return 1;
  
  while (len-- && (c = getc(f)) != EOF && c)
    *s++ = c;
  *s = '\0';

  return 0;
}

int
pqGetInt(int* result, int bytes, FILE* f)
{
  int c;
  int p;
  int n;

  if (f == NULL)
    return 1;
  
  p = 0;
  n = 0;
  while (bytes && (c = getc(f)) != EOF)
    {
      n |= (c & 0xff) << p;
      p += 8;
      bytes--;
    }

  if (bytes != 0)
    return 1;

  *result = n;
  return 0;
}


int
pqPuts(char* s, FILE* f)
{
  int c;

  if (f == NULL)
    return 1;
  
  if (fputs(s,f) == EOF)
    return 1;

  fputc('\0',f); /* important to send an ending EOF since backend expects it */
  fflush(f);
  return 0;
}

