/*-------------------------------------------------------------------------
 *
 * relcache.h--
 *    Relation descriptor cache definitions.
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * relcache.h,v 1.3 1995/04/15 00:29:09 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef	RELCACHE_H
#define RELCACHE_H

#include <sys/types.h>

#include "postgres.h"
#include "utils/rel.h"

/*
 * relation lookup routines
 */
extern Relation RelationIdCacheGetRelation(Oid relationId);
extern Relation RelationNameCacheGetRelation(Name relationName);
extern Relation RelationIdGetRelation(Oid relationId);
extern Relation RelationNameGetRelation(Name relationName);
extern Relation getreldesc(Name relationName);

extern void RelationClose(Relation relation);
extern void RelationFlushRelation(Relation *relationPtr,
				  bool	onlyFlushReferenceCountZero);
extern void RelationIdInvalidateRelationCacheByRelationId(Oid relationId);

extern void 
RelationIdInvalidateRelationCacheByAccessMethodId(Oid accessMethodId);

extern void RelationCacheInvalidate(bool onlyFlushReferenceCountZero);

extern void RelationRegisterRelation(Relation relation);
extern void RelationPurgeLocalRelation(bool xactComitted);
extern void RelationInitialize();
extern void init_irels();
extern void write_irels();


#endif	/* RELCACHE_H */
