/*-------------------------------------------------------------------------
 *
 * command.h--
 *    prototypes for command.c.
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * command.h,v 1.1.1.1 1994/11/07 05:19:26 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef COMMAND_H
#define COMMAND_H

#include "utils/portal.h"
#include "tcop/dest.h"

extern MemoryContext PortalExecutorHeapMemory;

/*
 * PortalCleanup --
 *	Cleans up the query state of the portal.
 *
 * Exceptions:
 *	BadArg if portal invalid.
 */
extern void PortalCleanup(Portal portal);


/*
 * PerformPortalFetch --
 *	Performs the POSTQUEL function FETCH.  Fetches count (or all if 0)
 * tuples in portal with name in the forward direction iff goForward.
 *
 * Exceptions:
 *	BadArg if forward invalid.
 *	"WARN" if portal not found.
 */
extern void PerformPortalFetch(String name, bool forward, int count,
			String tag, CommandDest dest);

/*
 * PerformPortalClose --
 *	Performs the POSTQUEL function CLOSE.
 */
extern void PerformPortalClose(String name, CommandDest dest);

/*
 * PerformAddAttribute --
 *	Performs the POSTQUEL function ADD.
 */
extern void PerformAddAttribute(Name relationName, Name userName,
				bool inh, ColumnDef *colDef);

#endif /* COMMAND_H */
