/*-------------------------------------------------------------------------
 *
 * bootstrap.h--
 *    include file for the bootstrapping code
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * bootstrap.h,v 1.4 1995/02/12 02:55:22 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef BOOTSTRAP_H
#define BOOTSTRAP_H

#include <sys/file.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>

#include "access/htup.h"
#include "access/itup.h"
#include "access/relscan.h"
#include "access/skey.h"
#include "utils/tqual.h"
#include "storage/buf.h"
#include "storage/bufmgr.h"	/* for BufferManagerFlush */
#include "utils/portal.h"
#include "utils/elog.h"
#include "utils/rel.h"

#define ALLOC(t, c)	(t *)calloc((unsigned)(c), sizeof(t))

#define FIRST_TYPE_OID 16	/* OID of the first type */
#define	MAXATTR 40		/* max. number of attributes in a relation */

/* ami_lexer.l */
#define STRTABLESIZE	10000
#define HASHTABLESIZE	503

/* Hash function numbers */
#define NUM	23
#define	NUMSQR	529
#define	NUMCUBE	12167

typedef struct hashnode {
    int		strnum;		/* Index into string table */
    struct hashnode	*next;
} hashnode;

typedef struct mcro {
    char *s;
    int  mderef;
} macro;

#define EMITPROMPT printf("> ")

extern Relation reldesc;
extern AttributeTupleForm attrtypes[MAXATTR];
extern int numattr;
extern int DebugMode;

extern int BootstrapMain(int ac, char *av[]);
extern void index_register(Name heap,
			   Name ind,
			   int natts,
			   AttrNumber *attnos,
			   uint16 nparams,
			   Datum *params,
			   FuncIndexInfo *finfo,
			   PredInfo *predInfo);

extern void err(void);
extern void InsertOneTuple(Oid objectid);
extern void createrel(char *name);
extern void closerel(char *name);
extern void boot_openrel(char *name);
extern char *LexIDStr(int ident_num);

extern void showtup(HeapTuple tuple, Buffer buffer, Relation relation);
extern void showtime(AbsoluteTime time);
extern void DefineAttr(char *name, char *type, int attnum);
extern void InsertOneValue(Oid objectid, char *value, int i);
extern void InsertOneNull(int i);
extern void defineindex(char *heapName, char *indexName,
			char *accessMethodName, List *attributeList);
extern bool BootstrapAlreadySeen(Oid id);
extern void cleanup(void);
extern int gettype(char *type);
extern AttributeTupleForm AllocateAttribute(void);
extern unsigned char MapEscape(char **s);
extern int EnterString (char *str);
extern int CompHash (char *str, int len);
extern hashnode *FindStr (char *str, int length, hashnode *mderef);
extern hashnode *AddStr(char *str, int strlength, int mderef);
extern void printhashtable(void);
extern void printstrtable(void);
extern char *emalloc (unsigned size);
extern int LookUpMacro(char *xmacro);
extern void DefineMacro(int indx1, int indx2);
extern void printmacros(void);
extern void build_indices(void);
extern void printrel();

#endif /* BOOTSTRAP_H */
