/*-------------------------------------------------------------------------
 *
 * xact.h--
 *    postgres transaction system header
 *
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 * xact.h,v 1.3 1994/11/11 08:09:44 andrew Exp
 *
 *-------------------------------------------------------------------------
 */
#ifndef XACT_H
#define XACT_H

#include <signal.h>

#include "storage/ipc.h"
#include "miscadmin.h"
#include "utils/portal.h"
#include "utils/elog.h"
#include "utils/mcxt.h"
#include "utils/nabstime.h"

/* ----------------
 *	transaction state structure
 * ----------------
 */
typedef struct TransactionStateData {
    TransactionId	transactionIdData;
    CommandId		commandId;
    AbsoluteTime		startTime;
    int			state;
    int			blockState;
} TransactionStateData;

/* ----------------
 *	transaction states
 * ----------------
 */
#define TRANS_DEFAULT		0
#define TRANS_START		1
#define TRANS_INPROGRESS	2
#define TRANS_COMMIT		3
#define TRANS_ABORT		4
#define TRANS_DISABLED		5

/* ----------------
 *	transaction block states
 * ----------------
 */
#define TBLOCK_DEFAULT		0
#define TBLOCK_BEGIN		1
#define TBLOCK_INPROGRESS	2
#define TBLOCK_END		3
#define TBLOCK_ABORT		4
#define TBLOCK_ENDABORT		5

typedef TransactionStateData *TransactionState;

/* ----------------
 *	extern definitions
 * ----------------
 */
extern int TransactionFlushEnabled();
extern void SetTransactionFlushEnabled(bool state);

extern bool IsTransactionState(void);
extern bool IsAbortedTransactionBlockState(void);
extern void OverrideTransactionSystem(bool flag);
extern TransactionId GetCurrentTransactionId(void);
extern CommandId GetCurrentCommandId(void);
extern AbsoluteTime GetCurrentTransactionStartTime(void);
extern bool TransactionIdIsCurrentTransactionId(TransactionId xid);
extern bool CommandIdIsCurrentCommandId(CommandId cid);
extern void ClearCommandIdCounterOverflowFlag(void);
extern void CommandCounterIncrement(void);
extern void InitializeTransactionSystem(void);
extern void AtStart_Cache(void);
extern void AtStart_Locks(void);
extern void AtStart_Memory(void);
extern void RecordTransactionCommit(void);
extern void AtCommit_Cache(void);
extern void AtCommit_Locks(void);
extern void AtCommit_Memory(void);
extern void RecordTransactionAbort(void);
extern void AtAbort_Cache(void);
extern void AtAbort_Locks(void);
extern void AtAbort_Memory(void);
extern void StartTransaction(void);
extern bool CurrentXactInProgress(void);
extern void CommitTransaction(void);
extern void AbortTransaction(void);
extern void StartTransactionCommand(void);
extern void CommitTransactionCommand(void);
extern void AbortCurrentTransaction(void);
extern void BeginTransactionBlock(void);
extern void EndTransactionBlock(void);
extern void AbortTransactionBlock(void);
extern bool IsTransactionBlock();

extern TransactionId DisabledTransactionId;

#endif	/* XACT_H */
