/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * MODULE NAME: 	stage3.c
 *
 * SCCSINFO:		@(#)stage3.c	1.5 5/3/94
 *
 * ORIGINAL AUTHOR(S):  Jens M Hansen, 1988-05-06
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 * File containing stage3, the one and only function of the CUTOFF
 * stage3 module.  stage3 compacts the molecule and data files of the
 * database.
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */
#include "cutoff.h"
#include "dbserver.h"		/* to get IT_SYSTEM_MOLECULE_LABEL */
#include "monitor.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_stage3.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_cutoffmain.h"
#include "f_files.h"
#include "f_flag.h"
#include "f_moveobject.h"
#include "f_pointers.h"

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* cutoffmain.c */
extern int global_indexfd;
extern off_t global_idxlen;

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: int stage3()
 *
 * compact molecule and data files
 * read REACHED flag
 * write MOVED flag
 *
 * Modifications:
 *      <list mods with name and date>
 */
int stage3()
{
  LABEL cur;
#ifdef REPORTNUMBER
  long count = REPORTNUMBER;
#endif
  long processed = 0;
  long moved = 0;

  (void)printf("stage3: starting\n");

  /* close and reopen all the old files to truncate them */
  truncate_old_files();

  /* go through index file */
  for (cur   = IT_SYSTEM_MOLECULE_LABEL; 
       cur < ConvToLabel(global_idxlen);
       cur += sizeof(INDEX)) {

#ifdef REPORTNUMBER
    if (count++ >= REPORTNUMBER) {
      (void)printf("Processed: %ld, Moved: %ld\n", processed, moved);
      count = 0;
    }
#endif

    processed++;
    if (is_flag_set(cur, CO_REACHED)) {
      if (MoveObject(cur) == FAIL)
	fatal_error(FATAL_GEN, "stage3", "move_object failed");
      moved++;
    }
  }
  (void)printf("Processed: %ld, Moved: %ld\n", processed, moved);
  (void)printf("stage3: finished\n");
  EndFileCache();
  return SUCCESS;
}
