.\" 
.\" Linkoping Intelligent Communication of Knowledge System (LINCKS)
.\"      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
.\"       Department of Computer and Information Sciences
.\"		University of Linkoping, Sweden
.\"		    581 83 Linkoping, Sweden
.\"		       lincks@ida.liu.se
.\"
.\" These collective LINCKS programs are free software; you can 
.\" redistribute them and/or modify them under the terms of the GNU
.\" General Public License as published by the Free Software Foundation,
.\" version 2 of the License.
.\"
.\" These programs are distributed in the hope that they will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with the programs; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\"
.\" dbs man page
.\" author: David Partain
.\" version:  @(#)dbs.l	1.8 5/27/94
.\"
.TH dbs l "5/27/94" IISLAB "LINCKS System"

.SH NAME
dbs - LINCKS database server
.SH SYNOPSIS
.B dbs
[
.B \-d
]
[
.B \-o
]   
[
.B \-h \fIhostname\fR
]
.B dbdir uid username fd
.SH DESCRIPTION
\fIdbs\fR is the LINCKS database client server. It is spawned by the
net server process (\fInetserv\fR) when a user logs in (using
xlincks(1)) to the database.  From that point on, the workspace
communicates with the \fIdbs\fR, which does the low-level database
activity -- storage, retrieval, etc.

There is only one \fImonitor\fR and \fInetserv\fR per database, and one
\fIdbs\fR per user process (client).

As a general rule, the user should never have to start a \fIdbs\fR
process.  Rather, the \fIdbs\fR is started by the \fInetserv\fR, which
is usually started by \fIlincks\fR.
.SH OPTIONS
.TP 
.B \-d
Run \fIdbs\fR in debug mode.  This is the default.  Debug output is
written to log files.
.TP
.B \-h \fIhostname\fR
Name of the machine running the database servers (\fImonitor\fR and
\fInetserv\fR).
.TP 
.B \-o
The \fIdbs\fR handles out\-band data to the client differently (to
avoid a bug in a few TCP implementations).
.TP
.B dbdir
The path to the database directory.
.TP
.B uid
The user identification number of the user starting the \fIdbs\fR
process.
.TP
.B username
The name of the user starting the \fIdbs\fR process.
.TP
.B fd
The file descriptor (socket number) used for communication.
.LP
The last four arguments are required.
.SH FILES
.TP
.B DBDIR/.lincksrc
Database Configuration File.
.TP
.B DBDIR/ITD*
Interface Table Dump files.  Can be removed safely.
.TP
.B LOGDIR/dbs.log
Log file for log and error messages.
.TP
.B /tmp/lincks.log
Last effort log file.
.SH SEE ALSO
netserv(l), monitor(l), lincks(l), xlincks(1), dbstat(1)
.SH DIAGNOSTICS
All logging is done to the file \fIdbs.log\fR in the LOGDIR specified in
the \fI.lincksrc\fR.

.SH BUGS
No known bugs.  Please report all bugs to lincks-bugs@ida.liu.se.
Please include a description of how you can reproduce the bug and the
output of either `dbx dbs core' or `gdb dbs core' if possible.
.SH COPYRIGHT
Copyright (C) 1993, 1994 Lin Padgham, Ralph Ronnquist
.LP
The collective LINCKS programs are free software; you can redistribute 
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation, version 2.
.LP
The collective LINCKS programs are distributed in the hope that they
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
the GNU General Public License for more details.
.LP
You should have received a copy of the GNU General Public License along
with the LINCKS system; see the file COPYING.  If not, write to the
Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.SH AVAILABILITY
The most recently released version of the LINCKS system is always 
available for anonymous ftp from ftp.ida.liu.se (130.236.30.131) in
the directory pub/lincks.
