/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	xdr.c
 *
 * SCCSINFO:		@(#)xdr.c	1.6 5/3/94
 *
 * ORIGINAL AUTHOR(S):  ???, 17 Jan, 1986
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	This file contains all the xdr translation functions
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <rpc/rpc.h>

#include "lincks.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_xdr.h"

/* 
 * these two functions are not used, but i didn't want to 
 * simply remove them, so i'll just shut lint up 
 */
#ifndef lint
int xdr_prot(/* XDR *xdrsp, P_ENTRY *p_entry */);
int xdr_setprot(/* XDR *xdrsp, S_ENTRY *s_entry */);
#endif

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#define XDR_PID(xdr,ptr) \
 ((sizeof(pid_t) == sizeof(int)) ? (xdr_int(xdr,ptr)) : (xdr_short(xdr,ptr)))

#ifdef LONG_64_BITS
#  define XDR_32BITS(xdr,ptr) xdr_int(xdr,ptr)
#else
#  define XDR_32BITS(xdr,ptr) xdr_long(xdr,ptr)
#endif /* n LONG_64_BITS */

#ifdef HAVE_XDR_HYPER
#  define XDR_64BITS(xdr,ptr) xdr_hyper(xdr,ptr)
#else
# ifdef HAVE_XDR_LONGLONG_T
#  define XDR_64BITS(xdr,ptr) xdr_longlong_t(xdr,ptr)    
# else
#  define XDR_64BITS(xdr,ptr) xdr_longlong(xdr,ptr)    
# endif /* n HAVE_XDR_LONGLONG_T */
#endif /* n HAVE_XDR_HYPER */

#ifdef SEEK_64_BITS
#  define XDR_FILEPOS(xdr,ptr) XDR_64BITS(xdr,ptr)
#else
#  define XDR_FILEPOS(xdr,ptr) XDR_32BITS(xdr,ptr)
#endif /* n SEEK_64_BITS */
#ifdef LABEL_64_BITS
#  define XDR_LABEL(xdr,ptr) XDR_64BITS(xdr,ptr)
#else
#  define XDR_LABEL(xdr,ptr) XDR_32BITS(xdr,ptr)
#endif /* LABEL_64_BITS */

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
#if !defined(HAVE_XDR_LONGLONG_T) && !defined(HAVE_XDR_HYPER) &&\
    (defined(LABEL_64_BITS) || defined(SEEK_64_BITS)) 
static inline int xdr_longlong(xdrsp,ptr)
  XDR *xdrsp;
  t_64bits *ptr;
{
  t_u64bits value = *ptr;
  t_32bits *buf;
  if (xdrsp->x_op == XDR_ENCODE) {
    t_u32bits low   = value & ~((t_u64bits)1 << 32);
    t_u32bits high  = value >> 32;

    if ((buf = XDR_INLINE(xdrsp, 2 * BYTES_PER_XDR_UNIT)) != NULL) {
      IXDR_PUT_U_LONG(buf, high);
      IXDR_PUT_U_LONG(buf, low);
      return(TRUE);
    }
    else 
      return(XDR_32BITS(xdrsp,&high) && 
             XDR_32BITS(xdrsp,&low));
  }
  if (xdrsp->x_op == XDR_DECODE) {
    t_u32bits low;
    t_u32bits high;

    if ((buf = XDR_INLINE(xdrsp, 2 * BYTES_PER_XDR_UNIT)) != NULL) {
      high = IXDR_GET_U_LONG(buf);
      low  = IXDR_GET_U_LONG(buf);
      *ptr    = ((t_u64bits)high << 32) | low ;
      return(TRUE);
    }
  }    
  {
    t_u32bits low;
    t_u32bits high;

    if (XDR_32BITS(xdrsp,&high) && 
	XDR_32BITS(xdrsp,&low)) {
      *ptr    = ((t_u64bits)high << 32) | low ;
      return(TRUE);
    } else
      return(FALSE);
  }
#if 0  
  t_u32bits low   = value & ~((t_u64bits)1 << 32);
  t_u32bits high  = value >> 32;
  switch(xdrsp->x_op) {
    case XDR_DECODE : 
      if (XDR_32BITS(xdrsp,&high) && 
          XDR_32BITS(xdrsp,&low)) {
        *ptr    = ((t_u64bits)high << 32) | low ;
	return(1);
      } else
	return(0);

    default:
      return(XDR_32BITS(xdrsp,&high) && 
             XDR_32BITS(xdrsp,&low));
  } /* switch */
#endif
}
#endif /* defined(LABEL_64_BITS) || defined(SEEK_64_BITS) */

/*  */
/**********************************************************************
 * Function: int xdr_pid(XDR *xdrsp, pid_t *pids)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_pid(xdrsp,pids)
  XDR *xdrsp;
  pid_t *pids;
{
  return(XDR_PID(xdrsp, pids));
}

/*  */
/**********************************************************************
 * Function: int xdr_access(XDR *xdrsp, A_ENTRY *a_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_access(xdrsp, a_entry)
  XDR *xdrsp;
  A_ENTRY *a_entry;
{
  return( xdr_int(xdrsp, &a_entry->a_status) &&
	  xdr_string(xdrsp, &a_entry->a_filename, MAXPATHLEN) &&
	  XDR_FILEPOS(xdrsp, &a_entry->a_filepos) &&
	  xdr_int(xdrsp, &a_entry->a_checkno) );
}

/*  */
/**********************************************************************
 * Function: int xdr_checkno(XDR *xdrsp, C_ENTRY *c_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_checkno(xdrsp, c_entry)
  XDR *xdrsp;
  C_ENTRY *c_entry;
{
    return( xdr_int(xdrsp, &c_entry->c_status) &&
	    xdr_int(xdrsp, &c_entry->c_checkno) );
}

/*  */
/**********************************************************************
 * Function: int xdr_new(XDR *xdrsp, N_ENTRY *n_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_new(xdrsp, n_entry)
  XDR *xdrsp;
  N_ENTRY *n_entry;
{
    return (xdr_int(xdrsp, &n_entry->n_status) &&
	    XDR_LABEL(xdrsp, &n_entry->n_label) &&
	    xdr_string(xdrsp, &n_entry->n_filename, MAXPATHLEN) &&
	    XDR_FILEPOS(xdrsp, &n_entry->n_filepos) &&
	    xdr_int(xdrsp, &n_entry->n_checkno) );
}

/*  */
/**********************************************************************
 * Function: int xdr_entry(XDR *xdrsp, L_ENTRY *l_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_entry(xdrsp, l_entry)
  XDR *xdrsp;
  L_ENTRY *l_entry;
{
#ifdef UID_INT
    return( XDR_LABEL(xdrsp, &l_entry->l_label) &&
	    xdr_int(xdrsp, &l_entry->l_uid) );
#else
    if (XDR_LABEL(xdrsp, &l_entry->l_label)) {
      unsigned short uid;
      
      uid = l_entry->l_uid;
      if ( xdr_u_short(xdrsp, &uid)) {
	l_entry->l_uid = uid;
        return(1);
      }
    }
    return(0);
#endif /* UID_INT */
}

/*  */
/**********************************************************************
 * Function: int xdr_update(XDR *xdrsp, U_ENTRY *u_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_update(xdrsp, u_entry)
  XDR *xdrsp;
  U_ENTRY *u_entry;
{
#ifdef UID_INT
    return( XDR_LABEL(xdrsp, &u_entry->u_label) &&
	    xdr_int(xdrsp, &u_entry->u_uid) &&
            xdr_string(xdrsp, &u_entry->u_filename, MAXPATHLEN) &&
            XDR_FILEPOS(xdrsp, &u_entry->u_filepos) );
#else
    if (XDR_LABEL(xdrsp, &u_entry->u_label)) {
      unsigned short uid;
      
      uid = u_entry->u_uid;
      if (xdr_u_short(xdrsp, &uid)) {
	u_entry->u_uid = uid;

	return( xdr_string(xdrsp, &u_entry->u_filename, MAXPATHLEN) &&
	        XDR_FILEPOS(xdrsp, &u_entry->u_filepos) );
      }
    }
    return(0);
#endif
}

/*  */
/**********************************************************************
 * Function: int xdr_edit(XDR *xdrsp, E_ENTRY *e_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_edit(xdrsp, e_entry)
  XDR *xdrsp;
  E_ENTRY *e_entry;
{
    return( XDR_LABEL(xdrsp, &e_entry->e_label) &&
	    xdr_string(xdrsp, &e_entry->e_usernames, MAXMESSAGELEN) );
}

/*  */
/**********************************************************************
 * Function: int xdr_remove(XDR *xdrsp, R_ENTRY *r_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_remove(xdrsp, r_entry)
  XDR *xdrsp;
  R_ENTRY *r_entry;
{
    return( XDR_LABEL(xdrsp, &r_entry->r_label) &&
	    XDR_PID(xdrsp, &r_entry->r_pid) &&
	    xdr_string(xdrsp, &r_entry->r_username, MAXMESSAGELEN) &&
	    xdr_int(xdrsp, &r_entry->r_flag) );
}

#ifndef lint
/*  */
/**********************************************************************
 * Function: int xdr_prot(XDR *xdrsp, P_ENTRY *p_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_prot(xdrsp, p_entry)
  XDR *xdrsp;
  P_ENTRY *p_entry;
{
    return( xdr_int(xdrsp, &p_entry->p_status) &&
	    xdr_u_short(xdrsp, &p_entry->p_wrperm) &&
	    xdr_u_short(xdrsp, &p_entry->p_rdperm) );
}

/*  */
/**********************************************************************
 * Function: int xdr_setprot(XDR *xdrsp, S_ENTRY *s_entry)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
int xdr_setprot(xdrsp, s_entry)
  XDR *xdrsp;
  S_ENTRY *s_entry;
{
#ifdef UID_INT
    return( XDR_LABEL(xdrsp, &s_entry->s_label) &&
	    xdr_int(xdrsp, &s_entry->s_uid) &&
	    xdr_u_short(xdrsp, &s_entry->s_wrperm) &&
	    xdr_u_short(xdrsp, &s_entry->s_rdperm) );
#else
    if ( XDR_LABEL(xdrsp, &s_entry->s_label) ) {
      unsigned short uid;
      
      uid = s_entry->s_uid;
      if (xdr_u_short(xdrsp, &uid)) {
	s_entry->s_uid = uid;
	return( xdr_u_short(xdrsp, &s_entry->s_wrperm) &&
	        xdr_u_short(xdrsp, &s_entry->s_rdperm) );
      }
    }
    return(0);
#endif
}
#endif
