/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1994, Martin Sjlin
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:         uu.c
 *
 * SCCSINFO:		@(#)uu.c	1.1 5/17/94
 *
 * ORIGINAL AUTHOR(S):  Martin Sjlin 1994-05-12
 *
 * DESCRIPTION:
 * This module contains function to decode and encode strings
 * to/from uuencoded format.
 * 
 * MODIFICATIONS:
 *	<list mods here with name and date>
 */

/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"			/* includes system  includes */
#include "machine.h"			/* t_u16bits etc */

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_uu.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
/* ENC is the basic 1 character encoding function to make a char printing */
#define ENC(c) ((c) ? ((c) & 077) + ' ': '`')

/* single character decode */
#define	DEC(c)	(((c) - ' ') & 077)		

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA:
 *********************************************************************/
/* none */

/*  */
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*********************************************************************
 * Function: int uudecode(char *bufcoded, char *bufplain);
 *
 * Modifications:
 *	<list mods here with name and date>
 *
 */
int uudecode(bufcoded, bufplain)
     char *bufcoded;
     char *bufplain;
{
           char *beginplain = bufplain;
  register int n;
  register char *p = bufcoded;

  /* for each input line */
  for (;;) {

    /* skip all white space ... */
    for(;*p == '\n' || *p == ' ' || *p == '\t';p++);
    
    if (*p == '\0') break;

    /*`n' is used to avoid writing out all the characters
     * at the end of the file. */
    if ((n = DEC(*p)) <= 0)
      break;

    for (++p; n > 0; p += 4, n -= 3)
      if (n >= 3) {
	*bufplain++ = DEC(p[0]) << 2 | DEC(p[1]) >> 4;
	*bufplain++ = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
	*bufplain++ = DEC(p[2]) << 6 | DEC(p[3]);
      }
      else {
	if (n >= 1) 
	  *bufplain++ = DEC(p[0]) << 2 | DEC(p[1]) >> 4;
	if (n >= 2) 
	  *bufplain++ = DEC(p[1]) << 4 | DEC(p[2]) >> 2;
	if (n >= 3) 
	  *bufplain++ = DEC(p[2]) << 6 | DEC(p[3]);
      }
  }
  return(bufplain - beginplain);
}

/*  */
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*********************************************************************
 * Function: char * uuencode (int size, char *inbuf, char *outbuf)
 *
 * bufcode should be a buffer big enough to contain the encoded
 * content in bufplain where the size is given by size. If bufcoded
 * is NULL, the routine allocates memory which the caller should free.
 *
 * Returns a pointer to buffer - either allocated or bufcoded, or 
 * NULL if allocation failed.
 *
 * Modifications:
 *	<list mods here with name and date>
 *
 */
char * uuencode (size, inbuf, outbuf)
 int size;
 char *inbuf;
 char *outbuf;
{
  char *beginout;

  register int ch, n;
  
  if (outbuf == NULL)
    if ((outbuf = malloc((ALLOC_T) 4 * size)) == NULL)
      return(NULL);

  beginout = outbuf;

  for(; size > 0; size -= (size > 45 ? 45 : size)) {
    n = size > 45 ? 45 : size;
    *outbuf++ = ENC(n);
    for (; n > 0; n -= 3, inbuf += 3) {
      ch = *inbuf >> 2;
      *outbuf++ = ENC(ch);
      if (n > 1) { 
	ch = ((*inbuf << 4) & 060) | ((inbuf[1] >> 4) & 017);
	*outbuf++ = ENC(ch);
      }
      if (n > 2) {
	ch = ((inbuf[1] << 2) & 074) | ((inbuf[2] >> 6) & 03);
	*outbuf++ = ENC(ch);
	ch = inbuf[2] & 077;
	*outbuf++ = ENC(ch);
      }
    } /* for n > 0 */
    *outbuf++ = '\n';
  } /* size > 0 */
  *outbuf++ = ENC('\0');
  *outbuf++= '\n';

  return(beginout);
}
