/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	logging.c
 *
 * SCCSINFO:		@(#)logging.c	1.7 5/3/94
 *
 * ORIGINAL AUTHOR(S):  ????, Feb, 1987
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *  This file contains logging stuff.  Used to be in logmsg.c and
 *  logfile.c.
 */
/*********************************************************************
 * INCLUDES:
 *********************************************************************/
#include "config.h"	/* includes system dependent includes */

#include <time.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif /* n __STDC__ */
#include "lincks.h"
#include "xconfig.h"

/*********************************************************************
 * EXTERNALLY-CALLABLE ROUTINES FOUND IN THIS MODULE:
 *********************************************************************/
#include "f_logging.h"

/*********************************************************************
 * EXTERNALLY-AVAILABLE	DATA FOUND IN THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
#include "f_xconfig.h"

/* libc */
#if defined(sun) || defined(__sun__)
extern time_t time P_((time_t *tloc));
#endif

/*********************************************************************
 * EXTERNAL DATA STRUCTURES USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * LOCAL DEFINES, STRUCTS, TYPEDEFS, ETC.:
 *********************************************************************/
#define BIGBUFFERSIZE 8192

/*********************************************************************
 * INTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/
/* none */

/*********************************************************************
 * INTERNAL (STATIC) DATA: 
 *********************************************************************/
/* none */

/*  */
/**********************************************************************
 * Function: void LogMessage(va_alist)
 *
 * Logs an error message on file
 * 
 * Modifications:
 *      <list mods with name and date>
 */
#ifdef lint
/*VARARGS2*//*ARGSUSED*/
void LogMessage(uid_, format_, va_alist)
    UID uid_;
    char *format_;
    va_dcl
#else
#ifdef __STDC__
void LogMessage(int uid, char *format, ...)
#else
void LogMessage(va_alist)
    va_dcl
#endif /* n __STDC__ */
#endif /* n lint */
{
    va_list ap;
#ifndef __STDC__
    int uid;		/* Assuming sizeof(UID) <= sizeof(int) */
    char *format;
#endif /* n __STDC__ */
    time_t secs;
    struct tm *t, *localtime();
    char msg[256];
    char userid[8];

    /* Get arguments */
#ifdef __STDC__
    va_start(ap, format);
#else
    va_start(ap);
    uid = va_arg(ap, int);
    format = va_arg(ap, char *);
#endif /* n __STDC__ */

    if (format == NULL)
	format = "(null)";

    /* Build message */
    (void)vsprintf(msg, format, ap);
    switch (uid) {
    case UNKNOWN:
	(void)strcpy(userid, "U");
	break;
    case SUPERUSER:
	(void)strcpy(userid, "S");
	break;
    default:
	(void)sprintf(userid, "%d", uid);
    }

    /* Get current time */
    (void)time(&secs);
    t = localtime(&secs);
	
    /* Print time followed by error message on file */
#ifdef DEBUG
    LogFile(NETSERVLOG, "%02d-%02d-%02d  %02d:%02d:%02d  Pid: %d User: (%s) %d  DB: %s\n                    %s\n\n",
		        t->tm_year, t->tm_mon+1, t->tm_mday,
			t->tm_hour, t->tm_min, t->tm_sec,
	   	        getpid(), userid, TCPIPNO, DBDIR, msg);

#else
    LogFile(NETSERVLOG, "%02d-%02d-%02d  %02d:%02d:%02d  User: (%s) %d  DB: %s\n                    %s\n\n",
		        t->tm_year, t->tm_mon+1, t->tm_mday,
			t->tm_hour, t->tm_min, t->tm_sec,
	   	        userid, TCPIPNO, DBDIR, msg);
#endif
    va_end(ap);
}
/*  */
/**********************************************************************
 * Function: void LogFile(va_alist)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
#ifdef lint
/*VARARGS2*/
/*ARGSUSED*/
void LogFile(file_, format_, va_alist)
    char *file_, *format_;
    va_dcl
#else
#ifdef __STDC__
void LogFile(char * file, char * format, ... )
#else
void LogFile(va_alist)
    va_dcl
#endif
#endif    
{
    va_list ap;
#ifndef __STDC__
    char *file;
    char *format;
#endif /* n __STDC__ */
    char filename[MAXPATHLEN];

    FILE *fp;
    static char filebuf[BIGBUFFERSIZE];

    /* Get arguments */
#ifdef __STDC__
    va_start(ap, format);
#else
    va_start(ap);
    file = va_arg(ap, char *);
    format = va_arg(ap, char *);
#endif /* n __STDC__ */

    /* Create full path-name for logfile. */
    (void)sprintf(filename, "%s/%s", LOGDIR, file);

    if ((fp = fopen(filename,"a")) != NULL) {
#ifdef _IOFBF
      (void)setvbuf( fp, filebuf, _IOFBF, BIGBUFFERSIZE);
#else
      (void)setbuffer( fp, filebuf, BIGBUFFERSIZE);
#endif
      (void)vfprintf(fp, format, ap);
    } else {
      (void)sprintf(filename, "%s/%s", LOGDIR, LINCKSLOG);
      if ((fp = fopen(filename,"a")) != NULL) {
	(void)fprintf(fp,"Failed to open log file for %s/%s\n", LOGDIR, file);
	(void)vfprintf(fp,format,ap);
      } else {
        (void)sprintf(filename, "/tmp/%s", LINCKSLOG);
        if ((fp = fopen(filename,"a")) != NULL) {
	  (void)fprintf(fp,"Failed to open log file for %s/%s\n",
			LOGDIR, file);
	  (void)fprintf(fp,"Failed to open log file for %s/%s\n",
			LOGDIR, LINCKSLOG);
	  (void)vfprintf(fp,format,ap);
	}
      }
    }
    (void)fclose(fp);

#ifdef DEBUG
    (void)vfprintf(stderr, format, ap);
#endif
    va_end(ap);
}
