/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1994, Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:         resources.h
 *
 * SCCSINFO:		@(#)resources.h	1.6 6/1/94
 *
 * ORIGINAL AUTHOR(S):  David Partain, 940120
 *
 * DESCRIPTION:
 *	This contains only the resources structure that is included in
 *	xstuff.c.  It seemed silly to change xstuff.c every time we want
 *	to set the fallback resource to something different.
 *
 * MODIFICATIONS:
 *	<list mods here with name and date>
 */

#ifndef RESOURCES_H
#define RESOURCES_H

static char *fallback_resources[] = { 
#if (XT_REVISION < 5)
  "xlincks*windowform.buttons*font: 5x8",
  "xlincks*windowform.buttons*shapeStyle: shapeOval",
  "xlincks*windowform.buttons*width: 60",
  "xlincks*windowform.buttons*borderWidth: 1",
  "xlincks*windowform.buttons*justify: justifyCenter",
  "Xlincks.ApplicationShell.Form.Form.Command.Translations: #augment \
	<Btn3Down>: 	set() \\n\
	<Btn3Up>:   do_help()",
  "xlincks*historypane.box*shapeStyle:  shapeOval",
  "xlincks*historypane.box.showGrip: False",
  "xlincks*historypane.box.close.font: 5x7",
  "xlincks*historypane.box.close.width: 80",
  "xlincks*historypane.box.dump.font: 5x7",
  "xlincks*historypane.box.dump.width: 80",
  "xlincks*refpane.box.showGrip: False",
  "xlincks*refpane.box*font: 5x7",
  "xlincks*refpane.box*shapeStyle: oval",
  "xlincks*refpane.scroll.length: 500",
  "xlincks*refpane.scroll.borderWidth: 0",
#else
  "xlincks.?.windowform.buttons.?.font: 5x8",
  "xlincks.?.windowform.buttons.?.shapeStyle: shapeOval",
  "xlincks.?.windowform.buttons.?.width: 60",
  "xlincks.?.windowform.buttons.?.borderWidth: 1",
  "xlincks.?.windowform.buttons.?.justify: justifyCenter",
  "xlincks.?.windowform.buttons.?.translations: #augment \
	<Btn3Down>: 	set() \\n\
	<Btn3Up>:	do_help() unset()",
  "xlincks.?.historypane.box.?.shapeStyle:  shapeOval",
  "xlincks.?.historypane.box.showGrip: False",
  "xlincks.?.historypane.box.close.font: 5x7",
  "xlincks.?.historypane.box.close.width: 80",
  "xlincks.?.historypane.box.dump.font: 5x7",
  "xlincks.?.historypane.box.dump.width: 80",
  "xlincks.?.refpane.box.showGrip: False",
  "xlincks.?.refpane.box.?.font: 5x7",
  "xlincks.?.refpane.box.?.shapeStyle: oval",
  "xlincks.?.refpane.scroll.length: 500",
  "xlincks.?.refpane.scroll.borderWidth: 0",
#endif
  "xlincks.popup.borderWidth: 2",
  "xlincks.popup.box.orientation: vertical",
  "xlincks.popup.box.title.font: 8x13",
  "xlincks.popup.box.title.shapeStyle: shapeOval",
  "xlincks.popup.box.title.justify: justifyCenter",
  "xlincks.popup.box.title.borderWidth: 1",
  "xlincks.popup.box.message.borderWidth: 0",
  "xlincks.popup.box.message.font: 9x15",
  "xlincks.popup.box.button.shapeStyle: shapeOval",
  "xlincks.popup.box.translations: #augment \
	<Key>Return:popdown_popup()",
#if (XT_REVISION < 5)
  "xlincks.popup.box*translations: #augment \
	<Key>Return:popdown_popup()",
#else
  "xlincks.popup.box.?.translations: #augment \
	<Key>Return:popdown_popup()",
#endif
  "xlincks.gpdmenu.height: 600",
  "xlincks.gpdmenu.width: 280",
  "xlincks.gpdmenu.scroll.borderWidth: 0",
  "xlincks.gpdmenu.scroll.list.font: 7x13bold",
  "xlincks.gpdmenu.scroll.list.defaultColumns: 1",
  "xlincks.export.allowShellResize: True",
#if (XT_REVISION < 5)
  "xlincks.export.exportform*font: 6x10",
  "xlincks.export.exportform*borderWidth: 0",
#else
  "xlincks.export.exportform.?.font: 6x10",
  "xlincks.export.exportform.?.borderWidth: 0",
#endif
  "xlincks.export.exportform.defaultDistance: 8",
  "xlincks.export.exportform.title.font:  9x15",
  "xlincks.export.exportform.title.justify: justifyCenter",
  "xlincks.export.exportform.label.borderWidth: 0",
  "xlincks.export.exportform.label.font: 7x13",
  "xlincks.export.exportform.type.borderWidth: 1",
  "xlincks.export.exportform.latex.font: 7x13bold",
  "xlincks.export.exportform.stylelabel.font: 7x13",
  "xlincks.export.exportform.style.borderWidth: 1",
  "xlincks.export.exportform.fontlabel.font: 7x13",
  "xlincks.export.exportform.font.borderWidth: 1",
  "xlincks.export.exportform.structlabel.font: 7x13",
  "xlincks.export.exportform.struct.borderWidth: 1",
  "xlincks.export.exportform.esclabel.font: 7x13",
  "xlincks.export.exportform.escape.borderWidth: 1",
  "xlincks.export.exportform.phlabel.font: 7x13",
  "xlincks.export.exportform.placeholder.borderWidth: 1",
  "xlincks.export.exportform.output.borderWidth: 1",
  "xlincks.export.exportform.output.font: 7x13bold",
  "xlincks.export.exportform.output.resizable: True",
  "xlincks.export.exportform.output.*.autoFill: False",
  "xlincks.export.exportform.status.font: 7x13bold",
  "xlincks.export.exportform.status.justify: justifyCenter",
  "xlincks.export.exportform.doit.font:   9x15",
  "xlincks.export.exportform.doit.borderWidth:  1",
  "xlincks.export.exportform.close.font:  9x15",
  "xlincks.export.exportform.close.borderWidth: 1",
  "xlincks.commandmenu.accelerators: #override \
	<Key>Help: wake-command-menu()",
  "xlincks.commandmenu.translations: #override \
	<Key>Help: wake-command-menu() \\n\
	<Btn1Up>: home-command-menu()",
  "xlincks.commandmenu.Add Link.translations: #augment \
	<Btn3Down>: set() \\n\
	<Btn3Up>:   do_help() unset() \\n\
	<Btn2Down>: set() \\n\
        <Btn2Up>: translinkcmd(before) unset()",
#if (XT_REVISION < 5)
  "xlincks.commandmenu*translations: #augment \
	<Btn3Down>: set() \\n\
	<Btn3Up>:   do_help() unset()",
  "xlincks.commandmenu*font: 7x13bold",
  "xlincks.commandmenu*width: 150",
#else
  "xlincks.commandmenu.?.translations: #augment \
	<Btn3Down>: set() \\n\
	<Btn3Up>:   do_help() unset()",
  "xlincks.commandmenu.?.font: 7x13bold",
  "xlincks.commandmenu.?.width: 150",
#endif
  "xlincks.commandmenu.width: 400",
  "xlincks.commandmenu.hSpace: 10",
  "xlincks.query.borderWidth: 3",
  "xlincks.query.pane.borderWidth: 0",
  "xlincks.query.pane.question.borderWidth: 0",
  "xlincks.query.pane.question.font: 7x13bold",
  "xlincks.query.pane.menu.borderWidth: 0",
  "xlincks.query.pane.menu.showGrip: False",
  "xlincks.query.pane.menu.orientation: horizontal",
  "xlincks.query.pane.menu.yes.borderWidth: 3",
#if (XT_REVISION < 5)
  "xlincks.query.pane.menu*shapeStyle: shapeOval",
  "xlincks.query.pane.menu*font: 9x15",
  "xlincks.query.pane.menu*translations: #augment \
	<Key>Return:popdown_yesnomenu()",
#else
  "xlincks.query.pane.menu.?.shapeStyle: shapeOval",
  "xlincks.query.pane.menu.?.font: 9x15",
  "xlincks.query.pane.menu.?.translations: #augment \
	<Key>Return:popdown_yesnomenu()",
#endif
  "xlincks.structedit.minWidth: 320",
  "xlincks.structedit.minHeight: 132",
  "xlincks.structedit.borderWidth: 3",
  "xlincks.structedit.streditform.defaultDistance: 8",
#if (XT_REVISION < 5)
  "xlincks.structedit.streditform*font: 8x13",
  "xlincks.structedit.streditform*width: 100",
#else
  "xlincks.structedit.streditform.?.font: 8x13",
  "xlincks.structedit.streditform.?.width: 100",
#endif
  "xlincks.structedit.streditform.close.width: 240",
  "xlincks.structedit.streditform.list.width: 300",
  "xlincks.fileinput.inputform.inputdialog.Execute.shapeStyle: oval",
  "xlincks.fileinput.inputform.inputdialog.Cancel.shapeStyle: oval",
  "xlincks.fileinput.inputform.inputdialog.*.autoFill: False",
  "xlincks.fileinput.inputform.*.font: 9x15",
  "Xlincks*graphWidgetClass*font: 6x10",
  (char *) NULL
};
#endif	/* RESOURCES_H */
