/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:         viewP.h
 *
 * SCCSINFO:            @(#)viewP.h	1.3 5/3/94
 *
 * ORIGINAL AUTHOR(S):  ???
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	Lincks XlView Widget which inherits from Athena Viewport widget.
 *
 **********************************************************************/
#ifndef _XlViewP_h
#define _XlViewP_h

#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/FormP.h>
#include "view.h"

typedef struct {
  int empty;
} XlViewClassPart;

typedef struct _XlViewClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    FormClassPart	form_class;
    ViewportClassPart	viewport_class;
    XlViewClassPart 	xlview_class;
} XlViewClassRec;

extern XlViewClassRec XlviewClassRec;

typedef struct {
  Dimension max_window_height;	/* max size of window without scrollbar */
  Dimension min_window_height;	/* min size of window without scrollbar */
} XlViewPart;

typedef struct _XlViewRec {
    CorePart	        core;
    CompositePart	composite;
    ConstraintPart	constraint;
    FormPart		form;
    ViewportPart	viewport;
    XlViewPart      	xlview;
} XlViewRec;

typedef struct _XlViewConstraintsPart {
    int mubble;
} XlViewConstraintsPart;

typedef struct _LincksFormConstraintsRec {
    FormConstraintsPart		form;
    ViewportConstraintsPart	viewport;
    XlViewConstraintsPart 	xl_view;
} XlViewConstraintsRec, *XlViewConstraints;


#endif /* _XlViewP_h */
