/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME:		ltextsrcP.h
 *
 * SCCSINFO:		@(#)ltextsrcP.h	1.2 5/3/94
 *
 * ORIGINAL AUTHOR(S):	
 *
 * MODIFICATIONS:
 *	<list mods with name and date>
 *
 * DESCRIPTION:
 *	Private file for XlTextSrc Widget
 */
#ifndef _XlTextSrcP_h
#define _XlTextSrcP_h

#include <X11/CoreP.h>
#include <X11/Xaw/TextSrcP.h>
#include "ltextsrc.h"

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRTemplateResource "TemplateResource"

/************************************************************
 *
 * Private declarations.
 *
 ************************************************************/

#define TMPSIZ 32		/* bytes to allocate for tmpnam */

#define MAGIC_VALUE ((XawTextPosition) -1) /* Magic value. */

#define streq(a, b)        ( strcmp((a), (b)) == 0 )

typedef struct _Piece {		/* Piece of the text file of BUFSIZ allocated 
				   characters. */
  char * text;			/* The text in this buffer. */
  XawTextPosition used;		/* The number of characters of this buffer 
				   that have been used. */
  struct _Piece *prev, *next;	/* linked list pointers. */
} Piece;


typedef struct {
    int empty;
} XlTextSrcClassPart;

/* Full class record declaration */
typedef struct _XlTextSrcClassRec {
    ObjectClassPart     object_class;
    TextSrcClassPart	text_src_class;
    XlTextSrcClassPart	xltextsrc_class;
} XlTextSrcClassRec;

extern XlTextSrcClassRec XltextsrcClassRec;

typedef struct {
  /* resources */
  char       *string;		/* the data string */
  XawTextPosition piece_size;	/* Size of text buffer for each piece. */
  Boolean data_compression;	/* compress to minimum memory automatically
				   on save? */
  XtCallbackList callback;	/* A callback list to call when the source is
				   changed. */
    /* private state */
  Boolean       allocated_string; /* Have I allocated the
				     string in ascii_src->string? */
  XawTextPosition length; 	/* length of file */
  Piece * first_piece;		/* first piece of the text. */
} XlTextSrcPart;

typedef struct _XlTextSrcRec {
  ObjectPart    object;
  TextSrcPart	text_src;
  XlTextSrcPart	xltext_src;
} XlTextSrcRec;

#endif /* _XlTextSrcP_h */
