/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltextaction.c: ltextscrolling.c
 *
 * SCCSINFO:		@(#)ltextscrolling.c	1.5 5/20/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions dealing with scrolling.
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * static void RedrawDisplay(Widget w, XEvent *event)
 * static void XlScrollFocus(TextWidget ctx)
 **********************************************************************/

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void RedrawDisplay(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void RedrawDisplay(w, event)
  Widget w;
  XEvent *event;
{
  Position y = XltextYForCurrentPosition((TextWidget) w);

  XlLayoutLostFocus(XtParent(w), y);
  XlViewCenterRow(XtParent(w), y);
  ClearLayout(XtParent(w));	/* send the parent widget... */
}


/*  */
/**********************************************************************
 * Function: static void XlScrollFocus(TextWidget ctx)
 * 
 * After each action check to see where the cursor is and automatically 
 * make the new location visible
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void XlScrollFocus(ctx)
  TextWidget ctx;
{
  int x, y, newx, newy;
  Window ignore;
  Widget gran;

  /* find the right widget */
  for (gran= (Widget) ctx; 
       !XtIsSubclass(gran,XlviewWidgetClass);
       gran=XtParent(gran)){
    if (gran == (Widget)NULL) {
      /* could put in an error message, but then we'd need an include :-) */
      return;
    }
  }

  x = ctx->text.ev_x;
  y = ctx->text.ev_y;
  (void) XTranslateCoordinates(XtDisplay(ctx), XtWindow(ctx), XtWindow(gran),
			       x, y, &newx, &newy, &ignore);
  XlViewAutoScroll(gran, newx, newy, XlSinkMaxHeight((TextSinkObject)ctx->text.sink,1));
}

