/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltextaction.c: ltextpublic.c
 *
 * SCCSINFO:		@(#)ltextpublic.c	1.5 6/6/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all the functions of the XlTextWidget that
 *	are available to clients.
 *	Actually these functions should really be vectorised through
 *	the class record as is the style of widgets, but but but ...
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * void _XlTextCheckResize(TextWidget ctx);
 * void XltextMove(TextWidget ctx, XEvent *event, XawTextScanDirection dir,
 *    	      XawTextScanType type, XtBoolean include);
 * int XltextMult(TextWidget w,int mult);
 * int XltextLastLineIndex(TextWidget w);
 * int XltextYForCurrentPosition(TextWidget ctx);
 * int XltextPoint(TextWidget ctx);
 * void XltextPlaceCursor(TextWidget ctx,int line);
 * void XltextSetFocus(Widget w, XtPosition y);
 */

/*  */
/**********************************************************************
 * Function: void _XlTextCheckResize(TextWidget ctx)
 * 
 * This routine checks to see if the window should be resized (grown or
 * shrunk) when text to be painted overflows to the right or
 * the bottom of the window. It is used by the keyboard input routine.
 *
 * Modifications:
 *      <list mods with name and date>
 */
void _XlTextCheckResize(ctx)
  TextWidget ctx;
{
  Widget w = (Widget) ctx;
  int line = 0, old_height;
  XtWidgetGeometry rbox;

  if ( (ctx->text.resize == XawtextResizeWidth) ||
       (ctx->text.resize == XawtextResizeBoth) ) {
    rbox.width = (Lines > 0) ? Info[0].textWidth : 0;
    for (line = 1; (Info[line].position != 0) && (line < Lines); line++) 
      AssignMax(rbox.width, Info[line].textWidth);
    
    rbox.width +=  LeftMargin + RightMargin;
    if (rbox.width > ctx->core.width) { /* Only get wider. */
      /* this is so it won't resize every character */
      rbox.width += 5 * CharWidth(ctx->text.sink, 0, 'M');
      rbox.request_mode = CWWidth;
      if (XtMakeGeometryRequest(w, &rbox, &rbox) == XtGeometryAlmost)
	(void) XtMakeGeometryRequest(w, &rbox, &rbox);
    }
  }

  if ( !((ctx->text.resize == XawtextResizeHeight) ||
	 (ctx->text.resize == XawtextResizeBoth)) )
      return;

  line =
    (IsPositionVisible(ctx, LastPos)) ?
      _XlLineForPosition(ctx, LastPos) : Lines;
  
  if ( (line + 1) == Lines ) return;
  
  old_height = ctx->core.height;
  rbox.request_mode = CWHeight;
  rbox.height = XawTextSinkMaxHeight(Sink, line + 1) + VMargins(ctx);
  
  if (rbox.height == old_height) return; /* It will only get taller. */

  if (XtMakeGeometryRequest(w, &rbox, &rbox) == XtGeometryAlmost)
    if (XtMakeGeometryRequest(w, &rbox, &rbox) != XtGeometryYes)
      return;
  
  _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE);
}


/*  */
/**********************************************************************
 * Function: void XltextMove(FIVE PARAMETERS)
 * Parameters:
 *	TextWidget ctx
 *	XEvent *event
 *	XawTextScanDirection dir
 *	XawTextScanType type
 *	XtBoolean include
 * 
 * Access the private Move function through a wrapper.
 *
 * Modifications:
 *      <list mods with name and date>
 */
void XltextMove(ctx, event, dir, type, include)
  TextWidget ctx;
  XEvent *event;
  XawTextScanDirection dir;
  XawTextScanType type;
  XtBoolean include;
{
  Move(ctx, event, dir, type, include);
}


/*  */
/**********************************************************************
 * Function: int XltextMult(TextWidget w,int mult)
 *
 * Set/get current action multiplier value.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int XltextMult(ctx,mult)
     TextWidget ctx;
     int mult;
{
  if (mult >= 0) Mult = mult;
  return Mult;
}


/*  */
/**********************************************************************
 * Function: int XltextLastLineIndex(TextWidget w)
 *
 * Returns number of lines less one.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int XltextLastLineIndex(ctx)
     TextWidget ctx;
{
  return _XlLineForPosition((TextWidget)ctx,LastPos);
}


/*  */
/**********************************************************************
 * Function: int XltextYForCurrentPosition(TextWidget ctx)
 *
 * Get current y coordinate.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int XltextYForCurrentPosition(ctx)
     TextWidget ctx;
{
  return ctx->core.y + Info[_XlLineForPosition(ctx,Point)].y;
}


/*  */
/**********************************************************************
 * Function: int XltextPoint(TextWidget ctx)
 *
 * Return current text insertion point
 *
 * Modifications:
 *      <list mods with name and date>
 */
int XltextPoint(ctx)
     TextWidget ctx;
{
  return (int) ctx->text.insertPos;
}


/*  */
/**********************************************************************
 * Function: void XltextPlaceCursor(TextWidget ctx,int line)
 *
 * Put cursor at line, at or near to goal column.
 *
 * Modifications:
 *      <list mods with name and date>
 */
void XltextPlaceCursor(ctx,line)
     TextWidget ctx;
     int line;
{
  PlaceCursor(ctx,line);
}


/*  */
/**********************************************************************
 * Function: int XltextSearchForward(THREE PARAMETERS)
 * Parameters:
 *	TextWidget ctx;
 *	XawTextPosition pos;
 *	char *text;
 *
 * Move point by searching text.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int XltextSearchForward(ctx,pos,str)
     TextWidget ctx;
     XawTextPosition pos;
     char *str;
{
  XawTextBlock text;

  if (!XtIsSubclass((Widget)ctx, XltextWidgetClass)) return -1;

  text.firstPos = 0;	text.length = strlen(str);
  text.ptr = str;	text.format = FMT8BIT;

  if ((pos = XawTextSourceSearch(Source,pos,XawsdRight,&text))
      == XawTextSearchError) {
    return -1;
  }

  StartAction(ctx,(XEvent *)NULL);
  _XawTextSetSelection(ctx,pos, (XawTextPosition)pos+strlen(str),
		       (String *)NULL,(Cardinal)0);
  Point = pos + strlen(str);
  EndAction(ctx);
  XlEndSearch((Widget)ctx,1);
  return (int) pos;
}


/*  */
/**********************************************************************
 * Function: int XltextSearchBackward(THREE PARAMETERS)
 * Parameters:
 *	TextWidget ctx;
 *	XawTextPosition pos;
 *	char *text;
 *
 * Move point by searching text.
 *
 * Modifications:
 *      <list mods with name and date>
 */
int XltextSearchBackward(ctx,pos,str)
     TextWidget ctx;
     XawTextPosition pos;
     char *str;
{
  XawTextBlock text;

  if (!XtIsSubclass((Widget)ctx, XltextWidgetClass)) return -1;

  if (pos < 0) pos = LastPos;

  text.firstPos = 0;	text.length = strlen(str);
  text.ptr = str;	text.format = FMT8BIT;

  if ((pos = XawTextSourceSearch(Source,pos,XawsdLeft,&text))
      == XawTextSearchError) {
    return -1;
  }

  StartAction(ctx,(XEvent *)NULL);
  _XawTextSetSelection(ctx,pos,(XawTextPosition)pos+strlen(str),
		       (String *)NULL,(Cardinal)0);
  Point = pos;
  EndAction(ctx);
  XlEndSearch((Widget)ctx,-1);
  return (int) pos;
}


/*  */
/**********************************************************************
 * Function: void XltextSetFocus(Widget w, XtPosition y)
 *
 * Set keyboard focus to w and move the point to row y.
 *
 * Modifications:
 *      <list mods with name and date>
 */
void XltextSetFocus(w, y)
  Widget w;
  XtPosition y;
{
  TextWidget ctx = (TextWidget)w;
  int w_y;
  int line;
  int caret = ctx->text.display_caret;

#ifdef DEBUG
  (void)fprintf(stderr, "entering XltextSetFocus\n");
  sync(XtDisplay(w));
#endif /* DEBUG */

  w_y = y - ctx->core.y;

  for (line = 0; line < Lines - 1; line++) {
    if (w_y < Info[line + 1].y) break;
  }
  PlaceCursor(ctx,line);
  if (!caret)
    XtSetKeyboardFocus(XtParent(w),w);
  XlLayoutFocusDetails(w,y);

#ifdef DEBUG
  (void)fprintf(stderr, "leaving XltextSetFocus\n");
  sync(XtDisplay(w));
#endif /* DEBUG */

}

/*  */
/**********************************************************************
 * Function: void XltextSetPenned(TextWidget w);
 *
 * Set or reset the `Pen' status on a Text Widget status,
 * used when redrawing/refreshing a window.
 *
 * Modifications:
 *      <list mods with name and date>
 */
void XltextSetPenned(w)
 XlTextWidget w;
{
  XlTextWidget ctx = (XlTextWidget) w;
  uim_highlight(ctx->xltext.reference->inode);
}
