/* 
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can 
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * MODULE NAME: 	ltextaction.c: ltextmovement.c
 *
 * SCCSINFO:		@(#)ltextmovement.c	1.5 6/6/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions dealing with (key command based)
 *	insert cursor movements.
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * static void Move(FIVE PARAMETERS)
 * static void MoveForwardChar(Widget w, XEvent *event)
 * static void MoveBackwardChar(Widget w, XEvent *event)
 * static void MoveForwardWord(Widget w, XEvent *event)
 * static void MoveBackwardWord(Widget w, XEvent *event)
 * static void MoveForwardParagraph(Widget w, XEvent *event)
 * static void MoveBackwardParagraph(Widget w, XEvent *event)
 * static void MoveToLineEnd(Widget w, XEvent *event)
 * static void MoveToLineStart(Widget w, XEvent *event)
 * static void PlaceCursor(TextWidget ctx,int line)
 * static void MoveLine(THREE PARAMETERS)
 * static void MoveNextLine(Widget w, XEvent *event)
 * static void MovePreviousLine(Widget w, XEvent *event)
 * static void MoveBeginningOfFile(Widget w, XEvent *event)
 * static void MoveEndOfFile(Widget w, XEvent *event)
 * static void MovePage(THREE PARAMETERS)
 * static void MoveNextPage(Widget w, XEvent *event)
 * static void MovePreviousPage(Widget w, XEvent *event)
 * static void TextSearch(widget w, XEvent *event)
 **********************************************************************/

/*  */
/**********************************************************************
 * Function: static void Move(FIVE PARAMETERS)
 * Parameters:
 *	TextWidget ctx
 *	XEvent *event
 *	XawTextScanDirection dir
 *	XawTextScanType type
 *	XtBoolean include
 *
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void Move(ctx, event, dir, type, include)
  TextWidget ctx;
  XEvent *event;
  XawTextScanDirection dir;
  XawTextScanType type;
  XtBoolean include;
{
  /* Check for spill-over to other item. */
  if ((event != (XEvent *)NULL) &&
      (((dir == XawsdLeft) && (Point == 0)) ||
       ((dir == XawsdRight) && (Point == LastPos)) ||
       (type == XawstEOL))) {
    /* The movement should maybe spill over to other item. */
    Xlgenhmove((Widget)ctx, event, dir, type, include);
    return;
  } 

  /* Execute the move within this item. */
  StartAction(ctx, event);

  Point = SrcScan(Source, Point, type, dir, Mult, include);

  EndAction(ctx);
}


/*  */
/**********************************************************************
 * Function: static void MoveForwardChar(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveForwardChar(w, event)
  Widget w;
  XEvent *event;
{
  Move((TextWidget) w, event, XawsdRight, XawstPositions, TRUE);
}


/*  */
/**********************************************************************
 * Function: static void MoveBackwardChar(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveBackwardChar(w, event)
  Widget w;
  XEvent *event;
{
  Move((TextWidget) w, event, XawsdLeft, XawstPositions, TRUE);
}


/*  */
/**********************************************************************
 * Function: static void MoveForwardWord(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveForwardWord(w, event)
  Widget w;
  XEvent *event;
{
  Move((TextWidget) w, event, XawsdRight, XawstWhiteSpace, FALSE);
}


/*  */
/**********************************************************************
 * Function: static void MoveBackwardWord(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveBackwardWord(w, event)
  Widget w;
  XEvent *event;
{
  Move((TextWidget) w, event, XawsdLeft, XawstWhiteSpace, FALSE);
}


/*  */
/**********************************************************************
 * Function: static void MoveForwardParagraph(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveForwardParagraph(w, event)
  Widget w;
  XEvent *event;
{
  Move((TextWidget) w, event, XawsdRight, XawstParagraph, FALSE);
}


/*  */
/**********************************************************************
 * Function: static void MoveBackwardParagraph(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveBackwardParagraph(w, event)
  Widget w;
  XEvent *event;
{
  Move((TextWidget) w, event, XawsdLeft, XawstParagraph, FALSE);
}


/*  */
/**********************************************************************
 * Function: static void MoveToLineEnd(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveToLineEnd(w, event)
  Widget w;
  XEvent *event;
{
  Move((TextWidget) w, event, XawsdRight, XawstEOL, FALSE);
  XlSetGoalColumn(w,32000);
  XlSkipGoalSet(w,1); /* Next up/down move should not set goal column */
}


/*  */
/**********************************************************************
 * Function: static void MoveToLineStart(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveToLineStart(w, event)
  Widget w;
  XEvent *event;
{
  Move((TextWidget) w, event, XawsdLeft, XawstEOL, FALSE);
  XlSetGoalColumn(w,0);
  XlSkipGoalSet(w,1); /* Next up/down move should not set goal column */
}


/*  */
/**********************************************************************
 * Function: static void PlaceCursor(TextWidget ctx,int line)
 *
 * Position text cursor at indicated line, at or near to goal column.
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void PlaceCursor(ctx, line)
     TextWidget ctx;
     int line;
{
  int unused;	/* Needed for FindPos, but not used. */
  int goal_column;

  StartAction(ctx,(XEvent *) NULL); /* To turn off visual cursor */

  goal_column = XlGetGoalColumn((Widget)ctx) - LeftMargin;

  if (goal_column < 0) goal_column = 0;

  FindPos(Sink, Info[line].position, LeftMargin, goal_column, FALSE,
	  &Point, &unused, &unused);

  if (Point >= LastPos)
    Point = LastPos;
  if (Point == Info[line+1].position)
    Point = SrcScan(Source,Info[line+1].position,
		    XawstPositions,XawsdLeft,1,TRUE);

  EndAction(ctx);	/* Turn on visual cursor. */
}


/*  */
/**********************************************************************
 * Function: static void MoveLine(THREE PARAMETERS)
 * Parameters:
 *	TextWidget ctx
 *	XEvent *event
 *	XawTextScanDirection dir
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveLine(ctx, event, dir)
  TextWidget ctx;
  XEvent *event;
  XawTextScanDirection dir;
{
  int newix, lineix, lastix, spill, goal_column;

  lineix = _XlLineForPosition(ctx,Point);
  lastix = _XlLineForPosition(ctx,LastPos);
  spill = Mult;
  newix = ((dir==XawsdLeft) ? (lineix-spill) : (lineix+spill));
  spill -= ((dir==XawsdLeft) ? lineix : (lastix - lineix));

  { /* Determine the value for tentative goal column. This value is
       used UNLESS the previous command was a MoveLine.
     */
    XawTextPosition unused1;	/* These are very temporary needs */
    int unused2;		/**/

    FindDist(Sink, Info[lineix].position, LeftMargin, Point,
	     &goal_column, &unused1, &unused2);

    XlSetGoalColumn((Widget)ctx,goal_column + LeftMargin);
  }

  if (spill <= 0) PlaceCursor(ctx,newix);
  else Xlgenvmove((Widget)ctx,event,dir,spill);

  XlSkipGoalSet((Widget)ctx,1); /* Next up/down move should not set goal column */

}


/*  */
/**********************************************************************
 * Function: static void MoveNextLine(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveNextLine(w, event)
  Widget w;
  XEvent *event;
{
  MoveLine( (TextWidget) w, event, XawsdRight);
}


/*  */
/**********************************************************************
 * Function: static void MovePreviousLine(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MovePreviousLine(w, event)
  Widget w;
  XEvent *event;
{
  MoveLine( (TextWidget) w, event, XawsdLeft);
}


/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void MoveBeginningOfFile(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveBeginningOfFile(w, event)
  Widget w;
  XEvent *event;
{
  Widget lw = XtParent((Widget)w);
  Widget child = XlFirstChild(w);

  XltextPlaceCursor((TextWidget)child, 0);
  XlLayoutLostFocus(lw, child->core.y);
  XlSkipGoalSet(child, 0);
  XlSetGoalColumn(child, 0);
  LayoutFocusIn(lw);
}


/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void MoveEndOfFile(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveEndOfFile(w, event)
  Widget w;
  XEvent *event;
{
  Widget lw = XtParent((Widget)w);
  Widget child = XlLastChild(w);
  int line = XlTextNumLines(child);

  XltextPlaceCursor((TextWidget)child, line);
  XlLayoutLostFocus(lw, child->core.y);
  XlSkipGoalSet(child, 0);
  XlSetGoalColumn(child, 0);
  LayoutFocusIn(lw);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void MovePage(THREE PARAMETERS)
 * Parameters:
 *	TextWidget ctx
 *	XEvent *event
 *	XawTextScanDirection dir
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MovePage(ctx, event, dir)
  TextWidget ctx;
  XEvent *event;
  XawTextScanDirection dir;
{
  Widget lw = XtParent((Widget)ctx);

  if (!XlViewPageScroll(lw,(dir == XawsdRight),ctx->core.y))
    return;

  XlLayoutLostFocus(lw, XlHomeChildY(lw));
  XlSkipGoalSet((Widget)ctx,0);
  XlSetGoalColumn((Widget)ctx,0);
  LayoutFocusIn(lw);
}


/*  */
/**********************************************************************
 * Function: static void MoveNextPage(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MoveNextPage(w, event)
  Widget w;
  XEvent *event;
{
  MovePage((TextWidget) w, event, XawsdRight);
}


/*  */
/**********************************************************************
 * Function: static void MovePreviousPage(Widget w, XEvent *event)
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void MovePreviousPage(w, event)
  Widget w;
  XEvent *event;
{
  MovePage((TextWidget) w, event, XawsdLeft);
}


/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void TextSearch(FOUR PARAMETERS)
 * Parameters:
 *	Widget w
 *	XEvent *event
 *	char *strtbl[]
 *	int n
 * 
 * Modifications:
 *      <list mods with name and date>
 */
static void TextSearch(w,event,strtbl,n)
     Widget w;
     XEvent *event;
     String *strtbl;
     Cardinal *n;
{
  if (*n != 1) { /* Wrong number of arguments */
    return;
  }

  XlBeginSearch(w,((*strtbl[0] == 'b') ? -1 : 1));
}
