/*
 * Linkoping Intelligent Communication of Knowledge System (LINCKS)
 *      Copyright (C) 1993, 1994 Lin Padgham, Ralph Rnnquist
 *       Department of Computer and Information Sciences
 *		University of Linkoping, Sweden
 *		    581 83 Linkoping, Sweden
 *		       lincks@ida.liu.se
 *
 * These collective LINCKS programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * General Public License as published by the Free Software Foundation,
 * version 2 of the License.
 *
 * These programs are distributed in the hope that they will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the programs; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * MODULE NAME: 	ltextaction.c: ltextdeletion.c
 *
 * SCCSINFO:		@(#)ltextdeletion.c	1.8 6/6/94
 *
 * ORIGINAL AUTHOR(S):  Ralph R\"onnquist, 1992-04-02
 *
 * NOTE:
 *	The file is INCLUDED in ltextaction.c, which also has the
 *	module header.
 *
 * MODIFICATIONS:
 *      1993-11-30 Martin Sjlin. Saves structures removed in DelPlural
 *            in the cut buffer.
 *      <list mods with name and date>
 *
 * DESCRIPTION:
 *	This file holds all functions dealing with deletion.
 *
 **********************************************************************/

/**********************************************************************
  FUNCTIONS DEFINED IN THIS FILE:
 **********************************************************************
 * Function: static void DelPlural(XlTextWidget w, XEvent *event)
 * Function: static void _DeleteOrKill(FOUR PARAMETERS)
 * Function: static void DeleteOrKill(SIX PARAMETERS)
 * Function: static void DeleteForwardChar(Widget w, XEvent *event)
 * Function: static void DeleteBackwardChar(Widget w, XEvent *event)
 * Function: static void DeleteForwardWord(Widget w, XEvent *event)
 * Function: static void DeleteBackwardWord(Widget w, XEvent *event)
 * Function: static void KillForwardWord(Widget w, XEvent *event)
 * Function: static void KillBackwardWord(TextWidget w, XEvent *event)
 * Function: static void JoinTextInternal(TextWidget ctx)
 * Function: static void JoinText(Widget w, XEvent *event)
 * Function: static void SplitText(Widget w, XEvent *event)
 * Function: static void KillToEndOfLine(Widget w, XEvent *event)
 * Function: static void KillToEndOfParagraph(Widget w, XEvent *event)
 **********************************************************************/

/*********************************************************************
 * EXTERNAL FUNCTIONS USED BY THIS MODULE:
 *********************************************************************/

extern int remove_infonode( /* infonode *where */ );	/* aimeditops.c */
extern int issingular( /* infonode *inode */ );	/* xstuff.c */
extern int XlSearching( /* Widget w */ );	/* layout.c */

/* Xaw: Text.c */
extern int _XawTextReplace(	/* TextWidget ctx, XawTextPosition pos1,
      			      XawTextPosition pos2, XawTextBlock *text */ );

/* aimcutbuf.c */
extern void copy_region( /* infonode *first, *last, int cut */ );

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void DelPlural(XlTextWidget w, XEvent *event)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void DelPlural(ctx, event)
  XlTextWidget ctx;
  XEvent *event;
{
  infonode *inp = Inode;
  int cnt = 0;

  if (ReferenceP->ref->flags.bound) {
    XBell(XtDisplay((Widget) ctx), 50);
    return;
  }
  for (inp = Inode; inp != (infonode *) NULL; inp = inp->parent) {
    if (!issingular(inp) && (cnt-- <= 0))
      break;
  }

  if (inp == (infonode *) NULL) {
    (void)fprintf(stderr, W_TOOMANY);
    (void)printf("Trying to cut a different way.\n");
    copy_region(Inode, Inode, 1);
    return;
  }
  if (inp->iflg & NONEXIST_MSK) {
    (void)fprintf(stderr, W_NOEXIST);
    XBell(XtDisplay((Widget) ctx), 50);
    return;
  }
  copy_region(inp, inp, 0);		/* 931130. msj */
  if (remove_infonode(inp) == FAIL) {
    (void)fprintf(stderr, W_NODEL);
    XBell(XtDisplay((Widget) ctx), 50);
    return;
  }
}

/*  */
/**********************************************************************
 * Function: static void _DeleteOrKill(FOUR PARAMETERS)
 * Parameters:
 *	TextWidget ctx
 *	XawTextPosition from
 *	XawTextPosition to
 *	XtBoolean kill
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void _DeleteOrKill(ctx, from, to, kill)
  TextWidget ctx;
  XawTextPosition from, to;
  XtBoolean kill;
{
  XawTextBlock text;
  XlTextWidget w = (XlTextWidget)ctx;
  char *ptr;

  if (kill && from < to) {
    ptr = _XawTextGetText(ctx, from, to);
    if (global_appendflag) { /* append to the kill buffer - set in SetAppend()*/
      char *current = NULL;
      char *newptr = NULL;
      int inbytes;

      (void)printf("Appending to the kill buffer.\n");
      current = XFetchBuffer(XtDisplay(ctx), &inbytes, 1);
      if (!(newptr = (char *)XtMalloc((Cardinal)(inbytes + (int)strlen(ptr) + 1)))) {
	(void)fprintf(stderr, "_DeleteOrKill: malloc failed.\n");
	return;
      }
      (void)sprintf(newptr, "%s%s", current, ptr);
      XtFree(current);
      XStoreBuffer(XtDisplay(ctx), newptr, strlen(newptr), 1);
      XtFree(newptr);
    } else {
      XStoreBuffer(XtDisplay(ctx), ptr, strlen(ptr), 1);
    }
    XtFree(ptr);
  }
  text.length = 0;
  text.firstPos = 0;
  if (_XawTextReplace(ctx, from, to, &text)) {
    XBell(XtDisplay(ctx), 50);
    return;
  }
  ctx->text.insertPos = from;
  ctx->text.showposition = TRUE;
  w->xltext.change_cnt += to - from;	/* ChangeFlag */
}

/*  */
/**********************************************************************
 * Function: static void DeleteOrKill(SIX PARAMETERS)
 * Parameters:
 *	TextWidget ctx
 *	XEvent *event
 *	XawTextScanDirection dir
 *	XawTextScanType type
 *	XtBoolean include
 *	XtBoolean kill
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void DeleteOrKill(ctx, event, dir, type, include, kill)
  TextWidget ctx;
  XEvent *event;
  XawTextScanDirection dir;
  XawTextScanType type;
  XtBoolean include, kill;
{
  XawTextPosition from, to;

  StartAction(ctx, event);
  to = SrcScan(ctx->text.source, ctx->text.insertPos,
	       type, dir, ctx->text.mult, include);

/*
 * If no movement actually happened, then bump the count and try again.
 * This causes the character position at the very beginning and end of
 * a boundry to act correctly.
 */

  if (to == ctx->text.insertPos)
    to = SrcScan(ctx->text.source, ctx->text.insertPos,
		 type, dir, ctx->text.mult + 1, include);

  if (dir == XawsdLeft) {
    from = to;
    to = ctx->text.insertPos;
  } else {
    from = ctx->text.insertPos;
  }

  _DeleteOrKill(ctx, from, to, kill);
  EndAction(ctx);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void DeleteForwardChar(TRANSLATION PARAMETERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void DeleteForwardChar(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  DeleteOrKill((TextWidget) w, event, XawsdRight, XawstPositions, TRUE, FALSE);
}

/*  */
/* ARGSUSED */
/**********************************************************************
 * Function: static void DeleteBackwardChar(TRANSLATION PARAMETERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void DeleteBackwardChar(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  if (XlSearching(w))
    XlDeleteSearchChar(w);
  else
    DeleteOrKill((TextWidget) w, event, XawsdLeft, XawstPositions, TRUE, FALSE);
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void DeleteForwardWord(TRANSLATION PARAMETERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void DeleteForwardWord(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  DeleteOrKill((TextWidget) w, event,XawsdRight, XawstWhiteSpace, FALSE, FALSE);
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void DeleteBackwardWord(TRANSLATION PARAMETERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void DeleteBackwardWord(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  DeleteOrKill((TextWidget) w, event, XawsdLeft, XawstWhiteSpace, FALSE, FALSE);
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void KillForwardWord(TRANSLATION PARAMTERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void KillForwardWord(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  DeleteOrKill((TextWidget) w, event, XawsdRight, XawstWhiteSpace, FALSE, TRUE);
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void KillBackwardWord(TRANSLATION PARAMTERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void KillBackwardWord(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  DeleteOrKill((TextWidget) w, event, XawsdLeft, XawstWhiteSpace, FALSE, TRUE);
}

/*  */
/**********************************************************************
 * Function: static void JoinTextInternal(TextWidget ctx)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void JoinTextInternal(ctx)
  TextWidget ctx;
{
  XlTextWidget fst;
  XlTextWidget nxw;
  String txt;
  Cardinal num = 1;

  fst = (XlTextWidget) XlChildIndex((Widget) ctx, 1);
  for (nxw = fst; nxw; nxw = (XlTextWidget) XlChildIndex((Widget) nxw, 1))
    if (!(nxw->xltext.reference->inode->iflg & NONEXIST_MSK))
      break;
  if (!nxw)
    return;

  txt = _XawTextGetText((TextWidget)nxw, 0, nxw->text.lastPos);	/* Calls XtMalloc */
  if (!txt)
    return;

  if (strlen(txt) == 0) {
    XtFree(txt);
    return;
  }
  /* NOTE: insertion point already at end of item. */
  /* When is it suitable to insert a newline prior to join? */
  (void)LocalInsertNewLine((TextWidget) ctx, (XEvent *) NULL);
  InsertString((Widget) ctx, (XEvent *) NULL, &txt, &num);
  XtFree(txt);
  XlSavetoDB((XlTextWidget)ctx);

  copy_region(fst->xltext.reference->inode, nxw->xltext.reference->inode, 1);
}


/*  */
/**********************************************************************
 * Function: static void JoinText(Widget w, XEvent *event)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void JoinText(w, event)
  Widget w;
  XEvent *event;
{
  TextWidget ctx = (TextWidget) w;

  StartAction(ctx, event);
  Point = SrcScan(Source, Point, XawstAll, XawsdRight, 1, TRUE);
  JoinTextInternal(ctx);
  EndAction(ctx);
}

/*  */
/**********************************************************************
 * Function: static void SplitText(Widget w, XEvent *event)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void SplitText(w, event)
  Widget w;
  XEvent *event;
{
  TextWidget ctx = (TextWidget) w;
  XlTextWidget xlctx = (XlTextWidget) w;
  String txt;
  XawTextPosition eol;

  eol = SrcScan(Source, Point, XawstAll, XawsdRight, 1, TRUE);
  if (eol == Point)
    return;

  txt = _XawTextGetText(ctx, Point, LastPos);	/* Calls XtMalloc */
  if (!txt)
    return;
  if (strlen(txt) == 0) {
    XtFree(txt);
    return;
  }
  make_cut_of_string(txt);
  if (!(paste(xlctx->xltext.reference->inode, 3))) {
    XBell(XtDisplay((Widget) ctx), 50);
    (void)printf("Could paste in subsequent item.  Split failed.\n");
    return;
  }
  StartAction(ctx, event);
  _DeleteOrKill((TextWidget) ctx, Point, LastPos, FALSE);
  EndAction(ctx);
  XlSavetoDB((XlTextWidget)ctx);

  XtFree(txt);
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void KillToEndOfLine(TRANSLATION PARAMETERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void KillToEndOfLine(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  TextWidget ctx = (TextWidget) w;
  XawTextPosition end_of_line;

  StartAction(ctx, event);
  end_of_line = SrcScan(ctx->text.source, ctx->text.insertPos, XawstEOL,
			XawsdRight, ctx->text.mult, FALSE);
  if (end_of_line == ctx->text.insertPos) {
    end_of_line = SrcScan(ctx->text.source, ctx->text.insertPos, XawstEOL,
			  XawsdRight, ctx->text.mult, TRUE);
#if 0
/* intended to make a kill at the end of the item do a join. */
/* david removed it because he didn't like the behavior. :-) */
    if (eol == Point) {
      JoinTextInternal(ctx);
      EndAction(ctx);
    }
#endif /* 0 */
  }
  _DeleteOrKill(ctx, ctx->text.insertPos, end_of_line, TRUE);
  EndAction(ctx);
}

/*  */
/*ARGSUSED*/
/**********************************************************************
 * Function: static void KillToEndOfParagraph(TRANSLATION PARAMTERS)
 *
 * Modifications:
 *      <list mods with name and date>
 */
static void KillToEndOfParagraph(w, event, p, n)
  Widget w;
  XEvent *event;
  String *p;
  Cardinal *n;
{
  DeleteOrKill((TextWidget) w, event, XawsdRight, XawstParagraph, FALSE, TRUE);
}

